/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.qrcode.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.google.zxing.ResultPoint;
import java.util.Collection;
import java.util.HashSet;
import pub.doric.devkit.R;
import pub.doric.devkit.qrcode.DisplayUtil;
import pub.doric.devkit.qrcode.camera.CameraManager;

public final class ViewfinderView
extends View {
    private static final long ANIMATION_DELAY = 100L;
    private static final int OPAQUE = 255;
    private final Paint paint = new Paint();
    private Bitmap resultBitmap;
    private final int maskColor;
    private final int resultColor;
    private final int resultPointColor;
    private Collection<ResultPoint> possibleResultPoints;
    private Collection<ResultPoint> lastPossibleResultPoints;
    private int scanLineTop;
    private int SCAN_VELOCITY;
    private Bitmap scanLight;
    private boolean isCircle;
    private int innercornercolor;
    private int innercornerlength;
    private int innercornerwidth;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ViewfinderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources resources = this.getResources();
        this.maskColor = resources.getColor(R.color.viewfinder_mask);
        this.resultColor = resources.getColor(R.color.result_view);
        this.resultPointColor = resources.getColor(R.color.possible_result_points);
        this.possibleResultPoints = new HashSet<ResultPoint>(5);
        this.scanLight = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.scan_light);
        this.initInnerRect(context, attrs);
    }

    private void initInnerRect(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView);
        float innerMarginTop = ta.getDimension(R.styleable.ViewfinderView_inner_margintop, -1.0f);
        if (innerMarginTop != -1.0f) {
            CameraManager.FRAME_MARGINTOP = (int)innerMarginTop;
        }
        CameraManager.FRAME_WIDTH = (int)ta.getDimension(R.styleable.ViewfinderView_inner_width, (float)(DisplayUtil.screenWidthPx / 2));
        CameraManager.FRAME_HEIGHT = (int)ta.getDimension(R.styleable.ViewfinderView_inner_height, (float)(DisplayUtil.screenWidthPx / 2));
        this.innercornercolor = ta.getColor(R.styleable.ViewfinderView_inner_corner_color, Color.parseColor((String)"#45DDDD"));
        this.innercornerlength = (int)ta.getDimension(R.styleable.ViewfinderView_inner_corner_length, 65.0f);
        this.innercornerwidth = (int)ta.getDimension(R.styleable.ViewfinderView_inner_corner_width, 15.0f);
        Drawable drawable2 = ta.getDrawable(R.styleable.ViewfinderView_inner_scan_bitmap);
        if (drawable2 != null) {
            // empty if block
        }
        this.scanLight = BitmapFactory.decodeResource((Resources)this.getResources(), (int)ta.getResourceId(R.styleable.ViewfinderView_inner_scan_bitmap, R.drawable.scan_light));
        this.SCAN_VELOCITY = ta.getInt(R.styleable.ViewfinderView_inner_scan_speed, 5);
        this.isCircle = ta.getBoolean(R.styleable.ViewfinderView_inner_scan_iscircle, true);
        ta.recycle();
    }

    public void onDraw(Canvas canvas) {
        Rect frame = CameraManager.get().getFramingRect();
        if (frame == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(255);
            canvas.drawBitmap(this.resultBitmap, (float)frame.left, (float)frame.top, this.paint);
        } else {
            this.drawFrameBounds(canvas, frame);
            this.drawScanLight(canvas, frame);
            Collection<ResultPoint> currentPossible = this.possibleResultPoints;
            Collection<ResultPoint> currentLast = this.lastPossibleResultPoints;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new HashSet<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(255);
                this.paint.setColor(this.resultPointColor);
                if (this.isCircle) {
                    for (ResultPoint point : currentPossible) {
                        canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 6.0f, this.paint);
                    }
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(127);
                this.paint.setColor(this.resultPointColor);
                if (this.isCircle) {
                    for (ResultPoint point : currentLast) {
                        canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 3.0f, this.paint);
                    }
                }
            }
            this.postInvalidateDelayed(100L, frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    private void drawScanLight(Canvas canvas, Rect frame) {
        if (this.scanLineTop == 0) {
            this.scanLineTop = frame.top;
        }
        this.scanLineTop = this.scanLineTop >= frame.bottom - 30 ? frame.top : (this.scanLineTop += this.SCAN_VELOCITY);
        Rect scanRect = new Rect(frame.left, this.scanLineTop, frame.right, this.scanLineTop + 30);
        canvas.drawBitmap(this.scanLight, null, scanRect, this.paint);
    }

    private void drawFrameBounds(Canvas canvas, Rect frame) {
        this.paint.setColor(this.innercornercolor);
        this.paint.setStyle(Paint.Style.FILL);
        int corWidth = this.innercornerwidth;
        int corLength = this.innercornerlength;
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + corWidth), (float)(frame.top + corLength), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + corLength), (float)(frame.top + corWidth), this.paint);
        canvas.drawRect((float)(frame.right - corWidth), (float)frame.top, (float)frame.right, (float)(frame.top + corLength), this.paint);
        canvas.drawRect((float)(frame.right - corLength), (float)frame.top, (float)frame.right, (float)(frame.top + corWidth), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - corLength), (float)(frame.left + corWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - corWidth), (float)(frame.left + corLength), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - corWidth), (float)(frame.bottom - corLength), (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - corLength), (float)(frame.bottom - corWidth), (float)frame.right, (float)frame.bottom, this.paint);
    }

    public void drawViewfinder() {
        this.resultBitmap = null;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        this.possibleResultPoints.add(point);
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

