/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.ui;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import pub.doric.devkit.DoricDevPerformanceAnchorHook;
import pub.doric.devkit.R;
import pub.doric.devkit.ui.DoricDevBaseActivity;
import pub.doric.performance.DoricPerformanceProfile;

public class DoricDevPerfActivity
extends DoricDevBaseActivity {
    private MyAdapter myAdapter;
    private TextView tvBtn;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_doricdev_perf);
        TextView textView = (TextView)this.findViewById(R.id.tv_title);
        textView.setText((CharSequence)String.format("%s <%s>", this.doricContext.getSource(), this.doricContext.getContextId()));
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.list);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.myAdapter = new MyAdapter();
        recyclerView.setAdapter((RecyclerView.Adapter)this.myAdapter);
        this.tvBtn = (TextView)this.findViewById(R.id.tv_button);
        this.tvBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DoricDevPerfActivity.this.myAdapter.isAllExpanded()) {
                    for (AnchorItem anchorItem : DoricDevPerfActivity.this.myAdapter.anchorNodes) {
                        anchorItem.expanded = false;
                    }
                } else {
                    for (AnchorItem anchorItem : DoricDevPerfActivity.this.myAdapter.anchorNodes) {
                        anchorItem.expanded = true;
                    }
                }
                DoricDevPerfActivity.this.myAdapter.notifyDataSetChanged();
                DoricDevPerfActivity.this.updateButton();
            }
        });
    }

    private void updateButton() {
        if (this.myAdapter.isAllExpanded()) {
            this.tvBtn.setText((CharSequence)"Collapse[-]");
        } else {
            this.tvBtn.setText((CharSequence)"Expand[+]");
        }
    }

    private class MyAdapter
    extends RecyclerView.Adapter<PerfCellHolder> {
        private final List<AnchorItem> anchorNodes = new LinkedList<AnchorItem>();
        private final long duration;

        private MyAdapter() {
            DoricPerformanceProfile.GlobalAnchorHook anchorHook = DoricDevPerfActivity.this.doricContext.getDriver().getRegistry().getGlobalPerformanceAnchorHook();
            long position = 0L;
            if (anchorHook instanceof DoricDevPerformanceAnchorHook) {
                DoricDevPerformanceAnchorHook.AnchorNode prevNode = null;
                for (DoricDevPerformanceAnchorHook.AnchorNode anchorNode : ((DoricDevPerformanceAnchorHook)anchorHook).getAnchorNodeList(DoricDevPerfActivity.this.doricContext.getContextId())) {
                    AnchorItem anchorItem = new AnchorItem();
                    anchorItem.name = anchorNode.name;
                    long gap = 0L;
                    if (prevNode != null) {
                        gap = Math.min(16L, anchorNode.prepare - prevNode.end);
                    }
                    anchorItem.position = (position += gap);
                    anchorItem.prepared = anchorNode.start - anchorNode.prepare;
                    anchorItem.worked = anchorNode.end - anchorNode.start;
                    this.anchorNodes.add(anchorItem);
                    position += anchorItem.prepared + anchorItem.worked;
                    prevNode = anchorNode;
                }
                this.duration = position;
            } else {
                this.duration = 0L;
            }
        }

        private boolean isAllExpanded() {
            boolean allExpanded = true;
            for (AnchorItem anchorItem : ((DoricDevPerfActivity)DoricDevPerfActivity.this).myAdapter.anchorNodes) {
                if (anchorItem.expanded) continue;
                allExpanded = false;
                break;
            }
            return allExpanded;
        }

        public PerfCellHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View cell = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_doricdev_perf, parent, false);
            PerfCellHolder cellHolder = new PerfCellHolder(cell);
            cellHolder.tvName = (TextView)cell.findViewById(R.id.tv_name);
            cellHolder.layoutWaterfall = (LinearLayout)cell.findViewById(R.id.layout_waterfall);
            cellHolder.waterfallPrepared = cell.findViewById(R.id.waterfall_prepared);
            cellHolder.waterfallWorked = cell.findViewById(R.id.waterfall_worked);
            cellHolder.waterfallPrefix = cell.findViewById(R.id.waterfall_prefix);
            cellHolder.waterfallSuffix = cell.findViewById(R.id.waterfall_suffix);
            cellHolder.layoutExpand = (LinearLayout)cell.findViewById(R.id.layout_expand);
            cellHolder.tvFuncName = (TextView)cell.findViewById(R.id.tv_func_name);
            cellHolder.tvParameter = (TextView)cell.findViewById(R.id.tv_parameter);
            cellHolder.tvCost = (TextView)cell.findViewById(R.id.tv_cost);
            return cellHolder;
        }

        public void onBindViewHolder(@NonNull PerfCellHolder holder, int position) {
            holder.itemView.setBackgroundColor(position % 2 == 0 ? 804373519 : 791596145);
            final AnchorItem anchorItem = this.anchorNodes.get(position);
            holder.layoutExpand.setVisibility(anchorItem.expanded ? 0 : 8);
            if (anchorItem.name.startsWith("Call")) {
                holder.tvName.setBackgroundColor(-13330213);
                holder.tvName.setText((CharSequence)"Call");
                String extraInfo = anchorItem.name.substring("Call:".length());
                String[] info = extraInfo.split(",");
                if (info.length > 1) {
                    holder.tvFuncName.setVisibility(0);
                    holder.tvFuncName.setText((CharSequence)info[0]);
                    holder.tvParameter.setVisibility(0);
                    holder.tvParameter.setText((CharSequence)extraInfo.substring(extraInfo.indexOf(",") + 1));
                } else if (info.length > 0) {
                    holder.tvFuncName.setVisibility(0);
                    holder.tvFuncName.setText((CharSequence)info[0]);
                    holder.tvParameter.setVisibility(8);
                } else {
                    holder.tvFuncName.setVisibility(8);
                    holder.tvParameter.setVisibility(8);
                }
            } else {
                if (anchorItem.name.equals("Render")) {
                    holder.tvName.setBackgroundColor(-1618884);
                } else {
                    holder.tvName.setBackgroundColor(-13710223);
                }
                holder.tvName.setText((CharSequence)anchorItem.name);
                holder.tvFuncName.setVisibility(8);
                holder.tvParameter.setVisibility(8);
            }
            ((LinearLayout.LayoutParams)((PerfCellHolder)holder).waterfallPrefix.getLayoutParams()).weight = anchorItem.position;
            ((LinearLayout.LayoutParams)((PerfCellHolder)holder).waterfallPrepared.getLayoutParams()).weight = anchorItem.prepared;
            ((LinearLayout.LayoutParams)((PerfCellHolder)holder).waterfallWorked.getLayoutParams()).weight = Math.max(anchorItem.worked, 1L);
            ((LinearLayout.LayoutParams)((PerfCellHolder)holder).waterfallSuffix.getLayoutParams()).weight = this.duration - anchorItem.position - anchorItem.prepared - anchorItem.worked;
            holder.layoutWaterfall.requestLayout();
            holder.tvCost.setText((CharSequence)String.format(Locale.getDefault(), "%d ms", anchorItem.prepared + anchorItem.worked));
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    anchorItem.expanded = !anchorItem.expanded;
                    MyAdapter.this.notifyDataSetChanged();
                    DoricDevPerfActivity.this.updateButton();
                }
            });
        }

        public int getItemCount() {
            return this.anchorNodes.size();
        }
    }

    private static class AnchorItem {
        private String name;
        private long position;
        private long prepared;
        private long worked;
        private boolean expanded;

        private AnchorItem() {
        }
    }

    private static class PerfCellHolder
    extends RecyclerView.ViewHolder {
        private TextView tvName;
        private LinearLayout layoutWaterfall;
        private View waterfallPrepared;
        private View waterfallWorked;
        private View waterfallPrefix;
        private View waterfallSuffix;
        private LinearLayout layoutExpand;
        private TextView tvFuncName;
        private TextView tvParameter;
        private TextView tvCost;

        private PerfCellHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}

