/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.ui;

import android.content.Context;
import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import pub.doric.devkit.R;
import pub.doric.devkit.ui.DoricDevBaseActivity;
import pub.doric.devkit.ui.treeview.DoricViewNodeLayoutItemType;
import pub.doric.devkit.ui.treeview.DoricViewNodeTreeViewBinder;
import pub.doric.devkit.ui.treeview.TreeNode;
import pub.doric.devkit.ui.treeview.TreeViewAdapter;
import pub.doric.shader.GroupNode;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;

public class DoricShowNodeTreeActivity
extends DoricDevBaseActivity {
    private RecyclerView rv;
    private TreeViewAdapter adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_show_node_tree);
        this.initView();
        this.initData();
    }

    private void initData() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode<DoricViewNodeLayoutItemType> root = new TreeNode<DoricViewNodeLayoutItemType>(new DoricViewNodeLayoutItemType((ViewNode)this.doricContext.getRootNode()));
        LinkedList<Object> viewQueue = new LinkedList<Object>();
        LinkedList<TreeNode<DoricViewNodeLayoutItemType>> treeQueue = new LinkedList<TreeNode<DoricViewNodeLayoutItemType>>();
        viewQueue.offer(this.doricContext.getRootNode());
        treeQueue.offer(root);
        while (!viewQueue.isEmpty()) {
            ViewNode viewNode = (ViewNode)viewQueue.poll();
            TreeNode treeNode = (TreeNode)treeQueue.poll();
            if (viewNode instanceof GroupNode) {
                GroupNode groupNode = (GroupNode)viewNode;
                for (int i = 0; i != groupNode.getChildNodes().size(); ++i) {
                    assert (treeNode != null);
                    TreeNode<DoricViewNodeLayoutItemType> temp = new TreeNode<DoricViewNodeLayoutItemType>(new DoricViewNodeLayoutItemType((ViewNode)groupNode.getChildNodes().get(i)));
                    treeNode.addChild(temp);
                    viewQueue.offer((ViewNode)groupNode.getChildNodes().get(i));
                    treeQueue.offer(temp);
                }
                continue;
            }
            if (!(viewNode instanceof SuperNode)) continue;
            SuperNode superNode = (SuperNode)viewNode;
            Set viewIds = superNode.getSubNodeViewIds();
            for (String viewId : viewIds) {
                assert (treeNode != null);
                TreeNode<DoricViewNodeLayoutItemType> temp = new TreeNode<DoricViewNodeLayoutItemType>(new DoricViewNodeLayoutItemType(superNode.getSubNodeById(viewId)));
                treeNode.addChild(temp);
                viewQueue.offer(superNode.getSubNodeById(viewId));
                treeQueue.offer(temp);
            }
        }
        nodes.add(root);
        this.rv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.adapter = new TreeViewAdapter(nodes, Collections.singletonList(new DoricViewNodeTreeViewBinder()));
        this.adapter.setOnTreeNodeListener(new TreeViewAdapter.OnTreeNodeListener(){

            @Override
            public boolean onClick(TreeNode node, RecyclerView.ViewHolder holder) {
                if (!node.isLeaf()) {
                    this.onToggle(!node.isExpand(), holder);
                }
                return false;
            }

            @Override
            public void onToggle(boolean isExpand, RecyclerView.ViewHolder holder) {
                DoricViewNodeTreeViewBinder.ViewHolder viewNodeTreeViewBinder = (DoricViewNodeTreeViewBinder.ViewHolder)holder;
            }
        });
        this.rv.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void initView() {
        this.rv = (RecyclerView)this.findViewById(R.id.show_node_tree_rv);
    }
}

