/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.github.pengfeizhou.jscore.ArchiveException;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSObject;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;
import pub.doric.devkit.R;
import pub.doric.devkit.ui.DoricFloatingView;
import pub.doric.shader.RootNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.ThreadMode;

@SuppressLint(value={"ViewConstructor"})
public class DoricSnapshotView
extends DoricFloatingView {
    private final DoricContext doricContext;
    private int snapNo = -1;
    private int snapSize = 0;
    private TextView snapIndex;
    private ImageView spanPre;
    private ImageView spanNext;

    public DoricSnapshotView(@NonNull Context context, DoricContext doricContext) {
        super(context);
        this.doricContext = doricContext;
        this.initView(context);
        this.setAlpha(0.8f);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_doric_dev_view_snapshot, (ViewGroup)this);
        this.snapIndex = (TextView)this.findViewById(R.id.snap_idx);
        this.spanPre = (ImageView)this.findViewById(R.id.snap_pre);
        this.spanNext = (ImageView)this.findViewById(R.id.snap_next);
        this.findViewById(R.id.snap_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DoricSnapshotView.this.rollupSnapshot(DoricSnapshotView.this.snapSize);
                ((ViewGroup)DoricSnapshotView.this.getParent()).removeView((View)DoricSnapshotView.this);
            }
        });
        this.doricContext.callEntity("__renderSnapshotDepth__", new Object[0]).setCallback((AsyncResult.Callback)new AsyncResult.Callback<JSDecoder>(){

            public void onResult(final JSDecoder result) {
                DoricSnapshotView.this.snapIndex.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DoricSnapshotView.this.snapSize = result.decode().asNumber().toInt();
                        }
                        catch (ArchiveException e) {
                            e.printStackTrace();
                        }
                        DoricSnapshotView.this.snapNo = DoricSnapshotView.this.snapSize;
                        DoricSnapshotView.this.rollupSnapshot(DoricSnapshotView.this.snapNo);
                        DoricSnapshotView.this.spanPre.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (DoricSnapshotView.this.snapNo <= 0) {
                                    return;
                                }
                                DoricSnapshotView.this.snapNo--;
                                DoricSnapshotView.this.rollupSnapshot(DoricSnapshotView.this.snapNo);
                            }
                        });
                        DoricSnapshotView.this.spanNext.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (DoricSnapshotView.this.snapNo >= DoricSnapshotView.this.snapSize) {
                                    return;
                                }
                                DoricSnapshotView.this.snapNo++;
                                DoricSnapshotView.this.rollupSnapshot(DoricSnapshotView.this.snapNo);
                            }
                        });
                    }
                });
            }

            public void onError(Throwable t) {
            }

            public void onFinish() {
            }
        });
    }

    private void rollupSnapshot(int index) {
        this.spanPre.setImageAlpha(index <= 0 ? 127 : 255);
        this.spanNext.setImageAlpha(index >= this.snapSize ? 127 : 255);
        this.snapIndex.setText((CharSequence)String.valueOf(index));
        this.doricContext.callEntity("__restoreRenderSnapshot__", new Object[]{index}).setCallback((AsyncResult.Callback)new AsyncResult.Callback<JSDecoder>(){

            public void onResult(JSDecoder result) {
                try {
                    final JSArray jsArray = result.decode().asArray();
                    DoricSnapshotView.this.doricContext.getDriver().asyncCall((Callable)new Callable<Object>(){

                        @Override
                        public Object call() {
                            if (DoricSnapshotView.this.doricContext.getContext() instanceof Activity && Build.VERSION.SDK_INT >= 17 && ((Activity)DoricSnapshotView.this.doricContext.getContext()).isDestroyed()) {
                                return null;
                            }
                            ((FrameLayout)DoricSnapshotView.this.doricContext.getRootNode().getView()).removeAllViews();
                            DoricSnapshotView.this.doricContext.getRootNode().clearSubModel();
                            for (int i = 0; i < jsArray.size(); ++i) {
                                JSObject jsObject = jsArray.get(i).asObject();
                                String viewId = jsObject.getProperty("id").asString().value();
                                RootNode rootNode = DoricSnapshotView.this.doricContext.getRootNode();
                                if (TextUtils.isEmpty((CharSequence)rootNode.getId()) && "Root".equals(jsObject.getProperty("type").asString().value())) {
                                    rootNode.setId(viewId);
                                    rootNode.blend(jsObject.getProperty("props").asObject());
                                    continue;
                                }
                                ViewNode viewNode = DoricSnapshotView.this.doricContext.targetViewNode(viewId);
                                if (viewNode == null) continue;
                                viewNode.blend(jsObject.getProperty("props").asObject());
                            }
                            return null;
                        }
                    }, ThreadMode.UI);
                }
                catch (ArchiveException e) {
                    e.printStackTrace();
                }
            }

            public void onError(Throwable t) {
            }

            public void onFinish() {
            }
        });
    }
}

