/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.ui.treeview;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import pub.doric.devkit.ui.treeview.LayoutItemType;

public class TreeNode<T extends LayoutItemType>
implements Cloneable {
    private T content;
    private TreeNode parent;
    private List<TreeNode> childList;
    private boolean isExpand;
    private boolean isLocked;
    private int height = -1;
    private static final int UNDEFINE = -1;

    public TreeNode(@NonNull T content) {
        this.content = content;
        this.childList = new ArrayList<TreeNode>();
    }

    public int getHeight() {
        if (this.isRoot()) {
            this.height = 0;
        } else if (this.height == -1) {
            this.height = this.parent.getHeight() + 1;
        }
        return this.height;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.childList == null || this.childList.isEmpty();
    }

    public void setContent(T content) {
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public List<TreeNode> getChildList() {
        return this.childList;
    }

    public void setChildList(List<TreeNode> childList) {
        this.childList.clear();
        for (TreeNode treeNode : childList) {
            this.addChild(treeNode);
        }
    }

    public TreeNode addChild(TreeNode node) {
        if (this.childList == null) {
            this.childList = new ArrayList<TreeNode>();
        }
        this.childList.add(node);
        node.parent = this;
        return this;
    }

    public boolean toggle() {
        this.isExpand = !this.isExpand;
        return this.isExpand;
    }

    public void collapse() {
        if (this.isExpand) {
            this.isExpand = false;
        }
    }

    public void collapseAll() {
        if (this.childList == null || this.childList.isEmpty()) {
            return;
        }
        for (TreeNode child : this.childList) {
            child.collapseAll();
        }
    }

    public void expand() {
        if (!this.isExpand) {
            this.isExpand = true;
        }
    }

    public void expandAll() {
        this.expand();
        if (this.childList == null || this.childList.isEmpty()) {
            return;
        }
        for (TreeNode child : this.childList) {
            child.expandAll();
        }
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode<T> lock() {
        this.isLocked = true;
        return this;
    }

    public TreeNode<T> unlock() {
        this.isLocked = false;
        return this;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String toString() {
        return "TreeNode{content=" + this.content + ", parent=" + (this.parent == null ? "null" : this.parent.getContent().toString()) + ", childList=" + (this.childList == null ? "null" : this.childList.toString()) + ", isExpand=" + this.isExpand + '}';
    }

    protected TreeNode<T> clone() throws CloneNotSupportedException {
        TreeNode<T> clone = new TreeNode<T>(this.content);
        clone.isExpand = this.isExpand;
        return clone;
    }
}

