/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.ui.treeview;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pub.doric.devkit.ui.treeview.TreeNode;
import pub.doric.devkit.ui.treeview.TreeViewBinder;
import pub.doric.utils.DoricUtils;

public class TreeViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String KEY_IS_EXPAND = "IS_EXPAND";
    private final List<? extends TreeViewBinder> viewBinders;
    private List<TreeNode> displayNodes;
    private int padding = DoricUtils.dp2px((float)15.0f);
    private OnTreeNodeListener onTreeNodeListener;
    private boolean toCollapseChild;

    public TreeViewAdapter(List<? extends TreeViewBinder> viewBinders) {
        this(null, viewBinders);
    }

    public TreeViewAdapter(List<TreeNode> nodes, List<? extends TreeViewBinder> viewBinders) {
        this.displayNodes = new ArrayList<TreeNode>();
        if (nodes != null) {
            this.findDisplayNodes(nodes);
        }
        this.viewBinders = viewBinders;
    }

    private void findDisplayNodes(List<TreeNode> nodes) {
        for (TreeNode node : nodes) {
            this.displayNodes.add(node);
            if (node.isLeaf() || !node.isExpand()) continue;
            this.findDisplayNodes(node.getChildList());
        }
    }

    public int getItemViewType(int position) {
        return this.displayNodes.get(position).getContent().getLayoutId();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(viewType, parent, false);
        if (this.viewBinders.size() == 1) {
            return this.viewBinders.get(0).provideViewHolder(v);
        }
        for (TreeViewBinder treeViewBinder : this.viewBinders) {
            if (treeViewBinder.getLayoutId() != viewType) continue;
            return treeViewBinder.provideViewHolder(v);
        }
        return this.viewBinders.get(0).provideViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (payloads != null && !payloads.isEmpty()) {
            Bundle b = (Bundle)payloads.get(0);
            Iterator iterator = b.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "IS_EXPAND": {
                        if (this.onTreeNodeListener == null) break;
                        this.onTreeNodeListener.onToggle(b.getBoolean(key), holder);
                    }
                }
            }
        }
        super.onBindViewHolder(holder, position, payloads);
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        if (Build.VERSION.SDK_INT >= 17) {
            holder.itemView.setPaddingRelative(this.displayNodes.get(position).getHeight() * this.padding, 3, 3, 3);
        } else {
            holder.itemView.setPadding(this.displayNodes.get(position).getHeight() * this.padding, 3, 3, 3);
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TreeNode selectedNode = (TreeNode)TreeViewAdapter.this.displayNodes.get(holder.getLayoutPosition());
                try {
                    long lastClickTime = (Long)holder.itemView.getTag();
                    if (System.currentTimeMillis() - lastClickTime < 500L) {
                        return;
                    }
                }
                catch (Exception e) {
                    holder.itemView.setTag((Object)System.currentTimeMillis());
                }
                holder.itemView.setTag((Object)System.currentTimeMillis());
                if (TreeViewAdapter.this.onTreeNodeListener != null && TreeViewAdapter.this.onTreeNodeListener.onClick(selectedNode, holder)) {
                    return;
                }
                if (selectedNode.isLeaf()) {
                    return;
                }
                if (selectedNode.isLocked()) {
                    return;
                }
                boolean isExpand = selectedNode.isExpand();
                int positionStart = TreeViewAdapter.this.displayNodes.indexOf(selectedNode) + 1;
                if (!isExpand) {
                    TreeViewAdapter.this.notifyItemRangeInserted(positionStart, TreeViewAdapter.this.addChildNodes(selectedNode, positionStart));
                } else {
                    TreeViewAdapter.this.notifyItemRangeRemoved(positionStart, TreeViewAdapter.this.removeChildNodes(selectedNode, true));
                }
            }
        });
        for (TreeViewBinder treeViewBinder : this.viewBinders) {
            if (treeViewBinder.getLayoutId() != this.displayNodes.get(position).getContent().getLayoutId()) continue;
            treeViewBinder.bindView(holder, position, this.displayNodes.get(position));
        }
    }

    private int addChildNodes(TreeNode pNode, int startIndex) {
        List<TreeNode> childList = pNode.getChildList();
        int addChildCount = 0;
        for (TreeNode treeNode : childList) {
            this.displayNodes.add(startIndex + addChildCount++, treeNode);
            if (!treeNode.isExpand()) continue;
            addChildCount += this.addChildNodes(treeNode, startIndex + addChildCount);
        }
        if (!pNode.isExpand()) {
            pNode.toggle();
        }
        return addChildCount;
    }

    private int removeChildNodes(TreeNode pNode) {
        return this.removeChildNodes(pNode, true);
    }

    private int removeChildNodes(TreeNode pNode, boolean shouldToggle) {
        if (pNode.isLeaf()) {
            return 0;
        }
        List<TreeNode> childList = pNode.getChildList();
        int removeChildCount = childList.size();
        this.displayNodes.removeAll(childList);
        for (TreeNode child : childList) {
            if (!child.isExpand()) continue;
            if (this.toCollapseChild) {
                child.toggle();
            }
            removeChildCount += this.removeChildNodes(child, false);
        }
        if (shouldToggle) {
            pNode.toggle();
        }
        return removeChildCount;
    }

    public int getItemCount() {
        return this.displayNodes == null ? 0 : this.displayNodes.size();
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void ifCollapseChildWhileCollapseParent(boolean toCollapseChild) {
        this.toCollapseChild = toCollapseChild;
    }

    public void setOnTreeNodeListener(OnTreeNodeListener onTreeNodeListener) {
        this.onTreeNodeListener = onTreeNodeListener;
    }

    public void refresh(List<TreeNode> treeNodes) {
        this.displayNodes.clear();
        this.findDisplayNodes(treeNodes);
        this.notifyDataSetChanged();
    }

    public Iterator<TreeNode> getDisplayNodesIterator() {
        return this.displayNodes.iterator();
    }

    private void notifyDiff(final List<TreeNode> temp) {
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

            public int getOldListSize() {
                return temp.size();
            }

            public int getNewListSize() {
                return TreeViewAdapter.this.displayNodes.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                return TreeViewAdapter.this.areItemsTheSame((TreeNode)temp.get(oldItemPosition), (TreeNode)TreeViewAdapter.this.displayNodes.get(newItemPosition));
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return TreeViewAdapter.this.areContentsTheSame((TreeNode)temp.get(oldItemPosition), (TreeNode)TreeViewAdapter.this.displayNodes.get(newItemPosition));
            }

            @Nullable
            public Object getChangePayload(int oldItemPosition, int newItemPosition) {
                return TreeViewAdapter.this.getChangePayload((TreeNode)temp.get(oldItemPosition), (TreeNode)TreeViewAdapter.this.displayNodes.get(newItemPosition));
            }
        });
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    private Object getChangePayload(TreeNode oldNode, TreeNode newNode) {
        Bundle diffBundle = new Bundle();
        if (newNode.isExpand() != oldNode.isExpand()) {
            diffBundle.putBoolean(KEY_IS_EXPAND, newNode.isExpand());
        }
        if (diffBundle.size() == 0) {
            return null;
        }
        return diffBundle;
    }

    private boolean areContentsTheSame(TreeNode oldNode, TreeNode newNode) {
        return oldNode.getContent() != null && oldNode.getContent().equals(newNode.getContent()) && oldNode.isExpand() == newNode.isExpand();
    }

    private boolean areItemsTheSame(TreeNode oldNode, TreeNode newNode) {
        return oldNode.getContent() != null && oldNode.getContent().equals(newNode.getContent());
    }

    public void collapseAll() {
        List<TreeNode> temp = this.backupDisplayNodes();
        ArrayList<TreeNode> roots = new ArrayList<TreeNode>();
        for (TreeNode treeNode : this.displayNodes) {
            if (!treeNode.isRoot()) continue;
            roots.add(treeNode);
        }
        for (TreeNode<Object> treeNode : roots) {
            if (!treeNode.isExpand()) continue;
            this.removeChildNodes(treeNode);
        }
        this.notifyDiff(temp);
    }

    @NonNull
    private List<TreeNode> backupDisplayNodes() {
        ArrayList<TreeNode> temp = new ArrayList<TreeNode>();
        for (TreeNode displayNode : this.displayNodes) {
            try {
                temp.add((TreeNode)displayNode.clone());
            }
            catch (CloneNotSupportedException e) {
                temp.add(displayNode);
            }
        }
        return temp;
    }

    public void collapseNode(TreeNode pNode) {
        List<TreeNode> temp = this.backupDisplayNodes();
        this.removeChildNodes(pNode);
        this.notifyDiff(temp);
    }

    public void collapseBrotherNode(TreeNode pNode) {
        List<TreeNode> temp = this.backupDisplayNodes();
        if (pNode.isRoot()) {
            ArrayList<TreeNode> roots = new ArrayList<TreeNode>();
            for (TreeNode treeNode : this.displayNodes) {
                if (!treeNode.isRoot()) continue;
                roots.add(treeNode);
            }
            for (TreeNode<Object> treeNode : roots) {
                if (!treeNode.isExpand() || treeNode.equals(pNode)) continue;
                this.removeChildNodes(treeNode);
            }
        } else {
            TreeNode parent = pNode.getParent();
            if (parent == null) {
                return;
            }
            List<TreeNode> childList = parent.getChildList();
            for (TreeNode node : childList) {
                if (node.equals(pNode) || !node.isExpand()) continue;
                this.removeChildNodes(node);
            }
        }
        this.notifyDiff(temp);
    }

    public static interface OnTreeNodeListener {
        public boolean onClick(TreeNode var1, RecyclerView.ViewHolder var2);

        public void onToggle(boolean var1, RecyclerView.ViewHolder var2);
    }
}

