/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.util;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class SimulatorUtil {
    private static String[] known_pipes = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe"};

    public static boolean isSimulator(Context context) {
        return SimulatorUtil.notHasBlueTooth() || SimulatorUtil.notHasLightSensorManager(context) || SimulatorUtil.isFeatures() || SimulatorUtil.checkIsNotRealPhone() || SimulatorUtil.checkPipes();
    }

    private static boolean notHasBlueTooth() {
        BluetoothAdapter ba = BluetoothAdapter.getDefaultAdapter();
        if (ba == null) {
            return true;
        }
        String name = ba.getName();
        return TextUtils.isEmpty((CharSequence)name);
    }

    private static boolean notHasLightSensorManager(Context context) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        Sensor sensor8 = null;
        if (sensorManager != null) {
            sensor8 = sensorManager.getDefaultSensor(5);
        }
        return null == sensor8;
    }

    private static boolean isFeatures() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    private static boolean checkIsNotRealPhone() {
        String cpuInfo = SimulatorUtil.readCpuInfo();
        return cpuInfo.contains("intel") || cpuInfo.contains("amd");
    }

    private static String readCpuInfo() {
        String result = "";
        try {
            String readLine;
            String[] args = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            StringBuilder sb = new StringBuilder();
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
            while ((readLine = responseReader.readLine()) != null) {
                sb.append(readLine);
            }
            responseReader.close();
            result = sb.toString().toLowerCase();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static boolean checkPipes() {
        for (String pipes : known_pipes) {
            File qemu_socket = new File(pipes);
            if (!qemu_socket.exists()) continue;
            Log.v((String)"Result:", (String)"Find pipes!");
            return true;
        }
        Log.i((String)"Result:", (String)"Not Find pipes!");
        return false;
    }
}

