/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.xbill.DNS.Address;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import se.unlogic.eagledns.CachedPrimaryZone;
import se.unlogic.eagledns.CachedSecondaryZone;
import se.unlogic.eagledns.DefaultRequest;
import se.unlogic.eagledns.SecondaryZone;
import se.unlogic.eagledns.Status;
import se.unlogic.eagledns.SystemInterface;
import se.unlogic.eagledns.TCPSocketMonitor;
import se.unlogic.eagledns.UDPSocketMonitor;
import se.unlogic.eagledns.ZoneChangeCallback;
import se.unlogic.eagledns.ZoneProviderUpdatable;
import se.unlogic.eagledns.plugins.Plugin;
import se.unlogic.eagledns.resolvers.Resolver;
import se.unlogic.eagledns.zoneproviders.ZoneProvider;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.numbers.LongCounter;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.settings.SettingNode;
import se.unlogic.standardutils.settings.XMLSettingNode;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.timer.RunnableTimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagleDNS
implements Runnable,
SystemInterface {
    public static final String VERSION_PREFIX = "Eagle DNS 1.1.1";
    public static final String VERSION;
    public final long startTime;
    public static final int FLAG_DNSSECOK = 1;
    public static final int FLAG_SIGONLY = 2;
    private final Logger log = Logger.getLogger(this.getClass());
    private ConcurrentHashMap<Name, CachedPrimaryZone> primaryZoneMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Name, CachedSecondaryZone> secondaryZoneMap = new ConcurrentHashMap();
    private final HashMap<Name, TSIG> TSIGs = new HashMap();
    private final HashMap<String, ZoneProvider> zoneProviders = new HashMap();
    private final ArrayList<Map.Entry<String, Resolver>> resolvers = new ArrayList();
    private final HashMap<String, Plugin> plugins = new HashMap();
    private int tcpThreadPoolMinSize = 10;
    private int tcpThreadPoolMaxSize = 50;
    private int udpThreadPoolMinSize = 10;
    private int udpThreadPoolMaxSize = 50;
    private int tcpThreadPoolShutdownTimeout = 60;
    private int udpThreadPoolShutdownTimeout = 60;
    private ArrayList<TCPSocketMonitor> tcpMonitorThreads = new ArrayList();
    private ArrayList<UDPSocketMonitor> udpMonitorThreads = new ArrayList();
    private ThreadPoolExecutor tcpThreadPool;
    private ThreadPoolExecutor udpThreadPool;
    private LongCounter rejectedTCPConnections = new LongCounter();
    private LongCounter rejectedUDPConnections = new LongCounter();
    private int axfrTimeout = 60;
    private Timer secondaryZoneUpdateTimer;
    private RunnableTimerTask timerTask;
    private Status status = Status.STARTING;
    private int defaultResponse;

    static {
        String tempVersion;
        try {
            tempVersion = "Eagle DNS 1.1.1 (rev. " + StringUtils.readStreamAsString(EagleDNS.class.getResourceAsStream("/META-INF/eagledns-svnrevision.txt")) + ")";
        }
        catch (Exception e) {
            tempVersion = "Eagle DNS 1.1.1.unknown";
        }
        VERSION = tempVersion;
    }

    public EagleDNS(String configFilePath) throws UnknownHostException {
        Integer axfrTimeout;
        Integer udpThreadPoolShutdownTimeout;
        Integer udpThreadPoolMaxSize;
        Integer udpThreadPoolMinSize;
        Integer tcpThreadPoolShutdownTimeout;
        Integer tcpThreadPoolMaxSize;
        XMLSettingNode configFile;
        this.startTime = System.currentTimeMillis();
        DOMConfigurator.configure((String)"conf/log4j.xml");
        System.out.println(String.valueOf(VERSION) + " starting...");
        this.log.fatal((Object)(String.valueOf(VERSION) + " starting..."));
        try {
            this.log.debug((Object)"Parsing config file...");
            configFile = new XMLSettingNode(configFilePath);
        }
        catch (Exception e) {
            this.log.fatal((Object)("Unable to open config file " + configFilePath + ", aborting startup!"));
            System.out.println("Unable to open config file " + configFilePath + ", aborting startup!");
            return;
        }
        boolean requireZones = configFile.getBoolean("/Config/System/RequireZones");
        String defaultResponse = configFile.getString("/Config/System/DefaultResponse");
        if (defaultResponse.equalsIgnoreCase("NOERROR")) {
            this.defaultResponse = 0;
        } else if (defaultResponse.equalsIgnoreCase("NXDOMAIN")) {
            this.defaultResponse = 3;
        } else {
            if (StringUtils.isEmpty(defaultResponse)) {
                this.log.fatal((Object)"No default response found, aborting startup!");
                System.out.println("No default response found, aborting startup!");
                return;
            }
            this.log.fatal((Object)("Invalid default response '" + defaultResponse + "' found, aborting startup!"));
            System.out.println("Invalid default response '" + defaultResponse + "' found, aborting startup!");
            return;
        }
        List<Integer> ports = configFile.getIntegers("/Config/System/Port");
        if (ports.isEmpty()) {
            this.log.debug((Object)("No ports found in config file " + configFilePath + ", using default port 53"));
            ports.add(new Integer(53));
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        List<String> addressStrings = configFile.getStrings("/Config/System/Address");
        if (addressStrings == null) {
            this.log.debug((Object)"No addresses found in config, listening on all addresses (0.0.0.0)");
            addresses.add(Address.getByAddress((String)"0.0.0.0"));
        } else {
            for (String addressString : addressStrings) {
                try {
                    addresses.add(Address.getByAddress((String)addressString));
                }
                catch (UnknownHostException e) {
                    this.log.error((Object)("Invalid address " + addressString + " specified in config file, skipping address " + e));
                }
            }
            if (addresses.isEmpty()) {
                this.log.fatal((Object)("None of the " + addressStrings.size() + " addresses specified in the config file are valid, aborting startup!\n" + "Correct the addresses or remove them from the config file if you want to listen on all interfaces."));
                System.out.println("None of the " + addressStrings.size() + " addresses specified in the config file are valid, aborting startup!\n" + "Correct the addresses or remove them from the config file if you want to listen on all interfaces.");
            }
        }
        Integer tcpThreadPoolMinSize = configFile.getInteger("/Config/System/TCPThreadPoolMinSize");
        if (tcpThreadPoolMinSize != null) {
            this.log.debug((Object)("Setting TCP thread pool min size to " + tcpThreadPoolMinSize));
            this.tcpThreadPoolMinSize = tcpThreadPoolMinSize;
        }
        if ((tcpThreadPoolMaxSize = configFile.getInteger("/Config/System/TCPThreadPoolMaxSize")) != null) {
            this.log.debug((Object)("Setting TCP thread pool max size to " + tcpThreadPoolMaxSize));
            this.tcpThreadPoolMaxSize = tcpThreadPoolMaxSize;
        }
        if ((tcpThreadPoolShutdownTimeout = configFile.getInteger("/Config/System/TCPThreadPoolShutdownTimeout")) != null) {
            this.log.debug((Object)("Setting TCP thread pool shutdown timeout to " + tcpThreadPoolShutdownTimeout + " seconds"));
            this.tcpThreadPoolShutdownTimeout = tcpThreadPoolShutdownTimeout;
        }
        if ((udpThreadPoolMinSize = configFile.getInteger("/Config/System/UDPThreadPoolMinSize")) != null) {
            this.log.debug((Object)("Setting UDP thread pool min size to " + udpThreadPoolMinSize));
            this.udpThreadPoolMinSize = udpThreadPoolMinSize;
        }
        if ((udpThreadPoolMaxSize = configFile.getInteger("/Config/System/UDPThreadPoolMaxSize")) != null) {
            this.log.debug((Object)("Setting UDP thread pool max size to " + udpThreadPoolMaxSize));
            this.udpThreadPoolMaxSize = udpThreadPoolMaxSize;
        }
        if ((udpThreadPoolShutdownTimeout = configFile.getInteger("/Config/System/UDPThreadPoolShutdownTimeout")) != null) {
            this.log.debug((Object)("Setting UDP thread pool shutdown timeout to " + udpThreadPoolShutdownTimeout + " seconds"));
            this.udpThreadPoolShutdownTimeout = udpThreadPoolShutdownTimeout;
        }
        if ((axfrTimeout = configFile.getInteger("/Config/System/AXFRTimeout")) != null) {
            this.log.debug((Object)("Setting AXFR timeout to " + axfrTimeout));
            this.axfrTimeout = axfrTimeout;
        }
        List<XMLSettingNode> zoneProviderElements = configFile.getSettings("/Config/ZoneProviders/ZoneProvider");
        for (SettingNode settingNode : zoneProviderElements) {
            String string = settingNode.getString("Name");
            if (StringUtils.isEmpty(string)) {
                this.log.error((Object)"ZoneProvider element with no name set found in config, ignoring element.");
                continue;
            }
            String className = settingNode.getString("Class");
            if (StringUtils.isEmpty(className)) {
                this.log.error((Object)"ZoneProvider element with no class set found in config, ignoring element.");
                continue;
            }
            try {
                this.log.debug((Object)("Instantiating zone provider " + string + " (" + className + ")"));
                ZoneProvider zoneProvider = (ZoneProvider)Class.forName(className).newInstance();
                this.log.debug((Object)("Zone provider " + string + " successfully instantiated"));
                List<? extends SettingNode> propertyElements = settingNode.getSettings("Properties/Property");
                for (SettingNode settingNode2 : propertyElements) {
                    String string2 = settingNode2.getString("@name");
                    if (StringUtils.isEmpty(string2)) {
                        this.log.error((Object)("Property element with no name set found in config for zone provider " + string + ", ignoring element"));
                        continue;
                    }
                    String value = settingNode2.getString(".");
                    this.log.debug((Object)("Found value " + value + " for property " + string2));
                    try {
                        Method method = zoneProvider.getClass().getMethod("set" + StringUtils.toFirstLetterUppercase(string2), String.class);
                        ReflectionUtils.fixMethodAccess(method);
                        this.log.debug((Object)("Setting property " + string2));
                        try {
                            method.invoke((Object)zoneProvider, value);
                        }
                        catch (IllegalArgumentException e) {
                            this.log.error((Object)("Unable to set property " + string2 + " on zone provider " + string + " (" + className + ")"), (Throwable)e);
                            System.out.println("Unable to set property " + string2 + " on zone provider " + string + " (" + className + ")");
                        }
                        catch (InvocationTargetException e) {
                            this.log.error((Object)("Unable to set property " + string2 + " on zone provider " + string + " (" + className + ")"), (Throwable)e);
                            System.out.println("Unable to set property " + string2 + " on zone provider " + string + " (" + className + ")");
                        }
                    }
                    catch (SecurityException e) {
                        this.log.error((Object)("Unable to find matching setter method for property " + string2 + " in zone provider " + string + " (" + className + ")"), (Throwable)e);
                        System.out.println("Unable to find matching setter method for property " + string2 + " in zone provider " + string + " (" + className + ")");
                    }
                    catch (NoSuchMethodException e) {
                        this.log.error((Object)("Unable to find matching setter method for property " + string2 + " in zone provider " + string + " (" + className + ")"), (Throwable)e);
                        System.out.println("Unable to find matching setter method for property " + string2 + " in zone provider " + string + " (" + className + ")");
                    }
                }
                try {
                    if (zoneProvider instanceof ZoneProviderUpdatable) {
                        ((ZoneProviderUpdatable)((Object)zoneProvider)).setChangeListener(new ZoneChangeCallback(){

                            public void zoneDataChanged() {
                                EagleDNS.this.reloadZones();
                            }
                        });
                    }
                    zoneProvider.init(string);
                    this.log.info((Object)("Zone provider " + string + " (" + className + ") successfully initialized!"));
                    System.out.println("Zone provider " + string + " (" + className + ") successfully initialized!");
                    this.zoneProviders.put(string, zoneProvider);
                }
                catch (Throwable throwable) {
                    this.log.error((Object)("Error initializing zone provider " + string + " (" + className + ")"), throwable);
                    System.out.println("Error initializing zone provider " + string + " (" + className + ")");
                }
            }
            catch (InstantiationException e) {
                this.log.error((Object)("Unable to create instance of class " + className + " for zone provider " + string), (Throwable)e);
                System.out.println("Unable to create instance of class " + className + " for zone provider " + string);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)("Unable to create instance of class " + className + " for zone provider " + string), (Throwable)e);
                System.out.println("Unable to create instance of class " + className + " for zone provider " + string);
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Unable to create instance of class " + className + " for zone provider " + string), (Throwable)e);
                System.out.println("Unable to create instance of class " + className + " for zone provider " + string);
            }
        }
        if (requireZones && this.zoneProviders.isEmpty()) {
            this.log.fatal((Object)"No started zone providers found, aborting startup! (disable the /Config/System/RequireZones property in configuration file if you wish to proceed without any zones or zone provider)");
            System.out.println("No started zone providers found, aborting startup! (disable the /Config/System/RequireZones property in configuration file if you wish to proceed without any zones or zone provider)");
            return;
        }
        this.reloadZones();
        if (requireZones && this.primaryZoneMap.isEmpty() && this.secondaryZoneMap.isEmpty()) {
            this.log.fatal((Object)"No zones found, aborting startup! (disable the /Config/System/RequireZones property in configuration file if you wish to proceed without any zones or zone provider)");
            System.out.println("No zones found, aborting startup! (disable the /Config/System/RequireZones property in configuration file if you wish to proceed without any zones or zone provider)");
            return;
        }
        List<XMLSettingNode> list = configFile.getSettings("/Config/Resolvers/Resolver");
        for (SettingNode settingNode : list) {
            String name = settingNode.getString("Name");
            if (StringUtils.isEmpty(name)) {
                this.log.error((Object)"Resolver element with no name set found in config, ignoring element.");
                System.out.println("Resolver element with no name set found in config, ignoring element.");
                continue;
            }
            String className = settingNode.getString("Class");
            if (StringUtils.isEmpty(className)) {
                this.log.error((Object)("Resolver element " + (String)name + " with no class set found in config, ignoring element."));
                System.out.println("Resolver element " + (String)name + " with no class set found in config, ignoring element.");
                continue;
            }
            try {
                this.log.debug((Object)("Instantiating resolver " + (String)name + " (" + className + ")"));
                Resolver resolver = (Resolver)Class.forName(className).newInstance();
                this.log.debug((Object)("Resolver " + (String)name + " successfully instantiated"));
                List<? extends SettingNode> list2 = settingNode.getSettings("Properties/Property");
                for (SettingNode settingNode3 : list2) {
                    String propertyName = settingNode3.getString("@name");
                    if (StringUtils.isEmpty(propertyName)) {
                        this.log.error((Object)("Property element with no name set found in config for resolver " + (String)name + ", ignoring element"));
                        System.out.println("Property element with no name set found in config for resolver " + (String)name + ", ignoring element");
                        continue;
                    }
                    String value = settingNode3.getString(".");
                    this.log.debug((Object)("Found value " + value + " for property " + propertyName));
                    try {
                        Method method = resolver.getClass().getMethod("set" + StringUtils.toFirstLetterUppercase(propertyName), String.class);
                        ReflectionUtils.fixMethodAccess(method);
                        this.log.debug((Object)("Setting property " + propertyName));
                        try {
                            method.invoke((Object)resolver, value);
                        }
                        catch (IllegalArgumentException e) {
                            this.log.error((Object)("Unable to set property " + propertyName + " on resolver " + (String)name + " (" + className + ")"), (Throwable)e);
                            System.out.println("Unable to set property " + propertyName + " on resolver " + (String)name + " (" + className + ")");
                        }
                        catch (InvocationTargetException e) {
                            this.log.error((Object)("Unable to set property " + propertyName + " on resolver " + (String)name + " (" + className + ")"), (Throwable)e);
                            System.out.println("Unable to set property " + propertyName + " on resolver " + (String)name + " (" + className + ")");
                        }
                    }
                    catch (SecurityException e) {
                        this.log.error((Object)("Unable to find matching setter method for property " + propertyName + " in resolver " + (String)name + " (" + className + ")"), (Throwable)e);
                        System.out.println("Unable to find matching setter method for property " + propertyName + " in resolver " + (String)name + " (" + className + ")");
                    }
                    catch (NoSuchMethodException e) {
                        this.log.error((Object)("Unable to find matching setter method for property " + propertyName + " in resolver " + (String)name + " (" + className + ")"), (Throwable)e);
                        System.out.println("Unable to find matching setter method for property " + propertyName + " in resolver " + (String)name + " (" + className + ")");
                    }
                }
                try {
                    resolver.setSystemInterface(this);
                    resolver.init(name);
                    this.log.info((Object)("Resovler " + (String)name + " (" + className + ") successfully initialized!"));
                    System.out.println("Resovler " + (String)name + " (" + className + ") successfully initialized!");
                    this.resolvers.add(new SimpleEntry<Object, Resolver>(name, resolver));
                }
                catch (Throwable throwable) {
                    this.log.error((Object)("Error initializing resolver " + (String)name + " (" + className + ")"), throwable);
                    System.out.println("Error initializing resolver " + (String)name + " (" + className + ")");
                }
            }
            catch (InstantiationException e) {
                this.log.error((Object)("Unable to create instance of class " + className + " for resolver " + (String)name), (Throwable)e);
                System.out.println("Unable to create instance of class " + className + " for resolver " + (String)name);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)("Unable to create instance of class " + className + " for resolver " + (String)name), (Throwable)e);
                System.out.println("Unable to create instance of class " + className + " for resolver " + (String)name);
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Unable to create instance of class " + className + " for resolver " + (String)name), (Throwable)e);
                System.out.println("Unable to create instance of class " + className + " for resolver " + (String)name);
            }
        }
        if (this.resolvers.isEmpty()) {
            this.log.fatal((Object)"No started resolvers found, aborting startup!");
            System.out.println("No started resolvers found, aborting startup!");
            return;
        }
        List<XMLSettingNode> list3 = configFile.getSettings("/Config/Plugins/Plugin");
        for (SettingNode settingNode : list3) {
            String name = settingNode.getString("Name");
            if (StringUtils.isEmpty(name)) {
                this.log.error((Object)"Plugin element with no name set found in config, ignoring element.");
                System.out.println("Plugin element with no name set found in config, ignoring element.");
                continue;
            }
            String className = settingNode.getString("Class");
            if (StringUtils.isEmpty(className)) {
                this.log.error((Object)("Plugin element " + name + " with no class set found in config, ignoring element."));
                System.out.println("Plugin element " + name + " with no class set found in config, ignoring element.");
                continue;
            }
            try {
                this.log.debug((Object)("Instantiating plugin " + name + " (" + className + ")"));
                Plugin plugin = (Plugin)Class.forName(className).newInstance();
                this.log.debug((Object)("Plugin " + name + " successfully instantiated"));
                List<? extends SettingNode> list4 = settingNode.getSettings("Properties/Property");
                for (SettingNode settingNode4 : list4) {
                    String propertyName = settingNode4.getString("@name");
                    if (StringUtils.isEmpty(propertyName)) {
                        this.log.error((Object)("Property element with no name set found in config for plugin " + name + ", ignoring element"));
                        System.out.println("Property element with no name set found in config for plugin " + name + ", ignoring element");
                        continue;
                    }
                    String value = settingNode4.getString(".");
                    this.log.debug((Object)("Found value " + value + " for property " + propertyName));
                    try {
                        Method method = plugin.getClass().getMethod("set" + StringUtils.toFirstLetterUppercase(propertyName), String.class);
                        ReflectionUtils.fixMethodAccess(method);
                        this.log.debug((Object)("Setting property " + propertyName));
                        try {
                            method.invoke((Object)plugin, value);
                        }
                        catch (IllegalArgumentException e) {
                            this.log.error((Object)("Unable to set property " + propertyName + " on plugin " + name + " (" + className + ")"), (Throwable)e);
                            System.out.println("Unable to set property " + propertyName + " on plugin " + name + " (" + className + ")");
                        }
                        catch (InvocationTargetException e) {
                            this.log.error((Object)("Unable to set property " + propertyName + " on plugin " + name + " (" + className + ")"), (Throwable)e);
                            System.out.println("Unable to set property " + propertyName + " on plugin " + name + " (" + className + ")");
                        }
                    }
                    catch (SecurityException e) {
                        this.log.error((Object)("Unable to find matching setter method for property " + propertyName + " in plugin " + name + " (" + className + ")"), (Throwable)e);
                        System.out.println("Unable to find matching setter method for property " + propertyName + " in plugin " + name + " (" + className + ")");
                    }
                    catch (NoSuchMethodException e) {
                        this.log.error((Object)("Unable to find matching setter method for property " + propertyName + " in plugin " + name + " (" + className + ")"), (Throwable)e);
                        System.out.println("Unable to find matching setter method for property " + propertyName + " in plugin " + name + " (" + className + ")");
                    }
                }
                try {
                    plugin.setSystemInterface(this);
                    plugin.init(name);
                    this.log.info((Object)("Plugin " + name + " (" + className + ") successfully initialized!"));
                    System.out.println("Plugin " + name + " (" + className + ") successfully initialized!");
                    this.plugins.put(name, plugin);
                }
                catch (Throwable throwable) {
                    this.log.error((Object)("Error initializing plugin " + name + " (" + className + ")"), throwable);
                    System.out.println("Error initializing plugin " + name + " (" + className + ")");
                }
            }
            catch (InstantiationException instantiationException) {
                this.log.error((Object)("Unable to create instance of class " + className + " for plugin " + name), (Throwable)instantiationException);
                System.out.println("Unable to create instance of class " + className + " for plugin " + name);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.error((Object)("Unable to create instance of class " + className + " for plugin " + name), (Throwable)illegalAccessException);
                System.out.println("Unable to create instance of class " + className + " for plugin " + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error((Object)("Unable to create instance of class " + className + " for plugin " + name), (Throwable)classNotFoundException);
                System.out.println("Unable to create instance of class " + className + " for plugin " + name);
            }
        }
        this.log.info((Object)"Initializing TCP thread pool...");
        this.tcpThreadPool = new ThreadPoolExecutor(this.tcpThreadPoolMinSize, this.tcpThreadPoolMaxSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true));
        this.log.info((Object)"Initializing UDP thread pool...");
        this.udpThreadPool = new ThreadPoolExecutor(this.udpThreadPoolMinSize, this.udpThreadPoolMaxSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true));
        for (InetAddress addr : addresses) {
            for (int port : ports) {
                try {
                    this.udpMonitorThreads.add(new UDPSocketMonitor(this, addr, port));
                }
                catch (SocketException socketException) {
                    this.log.error((Object)("Unable to open UDP server socket on address " + addr + ":" + port + ", " + socketException));
                }
                try {
                    this.tcpMonitorThreads.add(new TCPSocketMonitor(this, addr, port));
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Unable to open TCP server socket on address " + addr + ":" + port + ", " + iOException));
                }
            }
        }
        if (this.tcpMonitorThreads.isEmpty() && this.udpMonitorThreads.isEmpty()) {
            this.log.fatal((Object)"Not bound on any sockets, aborting startup!");
            System.out.println("Not bound on any sockets, aborting startup!");
            return;
        }
        this.log.info((Object)"Starting secondary zone update timer...");
        this.timerTask = new RunnableTimerTask(this);
        this.secondaryZoneUpdateTimer = new Timer();
        this.secondaryZoneUpdateTimer.schedule((TimerTask)this.timerTask, 60000L, 60000L);
        this.log.fatal((Object)(String.valueOf(VERSION) + " started with " + this.primaryZoneMap.size() + " primary zones and " + this.secondaryZoneMap.size() + " secondary zones, " + this.zoneProviders.size() + " Zone providers and " + this.resolvers.size() + " resolvers"));
        System.out.println(String.valueOf(VERSION) + " started with " + this.primaryZoneMap.size() + " primary zones and " + this.secondaryZoneMap.size() + " secondary zones, " + this.zoneProviders.size() + " Zone providers and " + this.resolvers.size() + " resolvers");
        this.status = Status.STARTED;
        System.out.close();
        System.err.close();
    }

    @Override
    public synchronized void shutdown() {
        if (this.status == Status.STARTING || this.status == Status.STARTED) {
            this.log.fatal((Object)("Shutting down " + VERSION + "..."));
            this.status = Status.SHUTTING_DOWN;
            this.log.info((Object)"Stopping secondary zone update timer...");
            this.timerTask.cancel();
            this.secondaryZoneUpdateTimer.cancel();
            this.log.info((Object)"Stopping TCP thread pool...");
            this.tcpThreadPool.shutdown();
            try {
                this.tcpThreadPool.awaitTermination(this.tcpThreadPoolShutdownTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                this.log.error((Object)("Timeout waiting " + this.tcpThreadPoolShutdownTimeout + " seconds for TCP thread pool to shutdown, forcing thread pool shutdown..."));
                this.tcpThreadPool.shutdownNow();
            }
            this.log.info((Object)"Stopping UDP thread pool...");
            this.udpThreadPool.shutdown();
            try {
                this.udpThreadPool.awaitTermination(this.udpThreadPoolShutdownTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                this.log.error((Object)("Timeout waiting " + this.udpThreadPoolShutdownTimeout + " seconds for UDP thread pool to shutdown, forcing thread pool shutdown..."));
                this.udpThreadPool.shutdownNow();
            }
            Iterator<Map.Entry<String, Plugin>> pluginIterator = this.plugins.entrySet().iterator();
            while (pluginIterator.hasNext()) {
                Map.Entry<String, Plugin> pluginEntry = pluginIterator.next();
                this.stopPlugin(pluginEntry, "plugin");
                pluginIterator.remove();
            }
            Iterator<Map.Entry<String, Resolver>> resolverIterator = this.resolvers.iterator();
            while (resolverIterator.hasNext()) {
                Map.Entry<String, Resolver> resolverEntry = resolverIterator.next();
                this.stopPlugin(resolverEntry, "resolver");
                resolverIterator.remove();
            }
            Iterator<Map.Entry<String, ZoneProvider>> zoneProviderIterator = this.zoneProviders.entrySet().iterator();
            while (zoneProviderIterator.hasNext()) {
                Map.Entry<String, ZoneProvider> zoneProviderEntry = zoneProviderIterator.next();
                this.stopPlugin(zoneProviderEntry, "zone provider");
                zoneProviderIterator.remove();
            }
            this.log.fatal((Object)(String.valueOf(VERSION) + " stopped"));
            System.exit(0);
        }
    }

    private void stopPlugin(Map.Entry<String, ? extends Plugin> pluginEntry, String type) {
        this.log.debug((Object)("Shutting down " + type + " " + pluginEntry.getKey() + "..."));
        try {
            pluginEntry.getValue().shutdown();
            this.log.info((Object)(String.valueOf(type) + " " + pluginEntry.getKey() + " shutdown"));
        }
        catch (Throwable t) {
            this.log.error((Object)("Error shutting down " + type + " " + pluginEntry.getKey()), t);
        }
    }

    @Override
    public synchronized void reloadZones() {
        ConcurrentHashMap<Name, CachedPrimaryZone> primaryZoneMap = new ConcurrentHashMap<Name, CachedPrimaryZone>();
        ConcurrentHashMap<Name, CachedSecondaryZone> secondaryZoneMap = new ConcurrentHashMap<Name, CachedSecondaryZone>();
        for (Map.Entry<String, ZoneProvider> zoneProviderEntry : this.zoneProviders.entrySet()) {
            Collection<SecondaryZone> secondaryZones;
            Collection<Zone> primaryZones;
            this.log.info((Object)("Getting primary zones from zone provider " + zoneProviderEntry.getKey()));
            try {
                primaryZones = zoneProviderEntry.getValue().getPrimaryZones();
            }
            catch (Throwable e) {
                this.log.error((Object)("Error getting primary zones from zone provider " + zoneProviderEntry.getKey()), e);
                continue;
            }
            if (primaryZones != null) {
                for (Zone zone : primaryZones) {
                    this.log.info((Object)("Got zone " + zone.getOrigin()));
                    primaryZoneMap.put(zone.getOrigin(), new CachedPrimaryZone(zone, zoneProviderEntry.getValue()));
                }
            }
            this.log.info((Object)("Getting secondary zones from zone provider " + zoneProviderEntry.getKey()));
            try {
                secondaryZones = zoneProviderEntry.getValue().getSecondaryZones();
            }
            catch (Throwable e) {
                this.log.error((Object)("Error getting secondary zones from zone provider " + zoneProviderEntry.getKey()), e);
                continue;
            }
            if (secondaryZones == null) continue;
            for (SecondaryZone zone : secondaryZones) {
                this.log.info((Object)("Got zone " + zone.getZoneName() + " (" + zone.getRemoteServerAddress() + ")"));
                CachedSecondaryZone cachedSecondaryZone = new CachedSecondaryZone(zoneProviderEntry.getValue(), zone);
                secondaryZoneMap.put(cachedSecondaryZone.getSecondaryZone().getZoneName(), cachedSecondaryZone);
            }
        }
        this.primaryZoneMap = primaryZoneMap;
        this.secondaryZoneMap = secondaryZoneMap;
    }

    private void addTSIG(String algstr, String namestr, String key) throws IOException {
        Name name = Name.fromString((String)namestr, (Name)Name.root);
        this.TSIGs.put(name, new TSIG(algstr, namestr, key));
    }

    @Override
    public Zone getZone(Name name) {
        CachedPrimaryZone cachedPrimaryZone = this.primaryZoneMap.get(name);
        if (cachedPrimaryZone != null) {
            return cachedPrimaryZone.getZone();
        }
        CachedSecondaryZone cachedSecondaryZone = this.secondaryZoneMap.get(name);
        if (cachedSecondaryZone != null && cachedSecondaryZone.getSecondaryZone().getZoneCopy() != null) {
            return cachedSecondaryZone.getSecondaryZone().getZoneCopy();
        }
        return null;
    }

    byte[] generateReply(Message query, byte[] in, int length, Socket socket, SocketAddress socketAddress) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing query " + EagleDNS.toString(query.getQuestion()) + " from " + socketAddress));
            this.log.debug((Object)("Full query:\n" + query));
        }
        Message response = null;
        DefaultRequest request = new DefaultRequest(socketAddress, query, in, length, socket);
        for (Map.Entry<String, Resolver> resolverEntry : this.resolvers) {
            try {
                response = resolverEntry.getValue().generateReply(request);
                if (response != null) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)("Resolver " + resolverEntry.getKey() + " responded to query " + EagleDNS.toString(query.getQuestion()) + " with response " + Rcode.string((int)response.getHeader().getRcode()) + " containing " + response.getSectionArray(1).length + " answer, " + response.getSectionArray(2).length + " authoritative and " + response.getSectionArray(3).length + " additional records"));
                    this.log.debug((Object)response);
                    break;
                }
                if (socket == null || !socket.isClosed()) continue;
                this.log.info((Object)("TCP response sent by resolver " + resolverEntry.getKey() + " for query " + EagleDNS.toString(query.getQuestion())));
                return null;
            }
            catch (Exception e) {
                this.log.error((Object)("Caught exception from resolver " + resolverEntry.getKey()), (Throwable)e);
            }
        }
        if (socket != null && socket.isClosed()) {
            return null;
        }
        OPTRecord queryOPT = query.getOPT();
        if (response == null) {
            response = this.getInternalResponse(query, in, length, socket, queryOPT);
            this.log.info((Object)("Got no response from resolvers for query " + EagleDNS.toString(query.getQuestion()) + " sending default response " + Rcode.string((int)this.defaultResponse)));
        }
        int maxLength = socket != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        return response.toWire(maxLength);
    }

    private Message getInternalResponse(Message query, byte[] in, int length, Socket socket, OPTRecord queryOPT) {
        boolean flags = false;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return EagleDNS.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return EagleDNS.errorMessage(query, 4);
        }
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null && ((tsig = this.TSIGs.get(queryTSIG.getName())) == null || tsig.verify(query, in, length, null) != 0)) {
            return this.formerrMessage(in);
        }
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = true;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.getHeader().setRcode(this.defaultResponse);
        Record queryRecord = query.getQuestion();
        response.addRecord(queryRecord, 0);
        int type = queryRecord.getType();
        if (type == 252 && socket != null) {
            return EagleDNS.errorMessage(query, 5);
        }
        if (!Type.isRR((int)type) && type != 255) {
            return EagleDNS.errorMessage(query, 4);
        }
        if (queryOPT != null) {
            int optflags = flags ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, this.defaultResponse, 0, optflags);
            response.addRecord((Record)opt, 3);
        }
        response.setTSIG(tsig, this.defaultResponse, queryTSIG);
        return response;
    }

    public static Message buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        int i = 0;
        while (i < 4) {
            response.removeAllRecords(i);
            ++i;
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response;
    }

    Message formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return EagleDNS.buildErrorMessage(header, 1, null);
    }

    public static Message errorMessage(Message query, int rcode) {
        return EagleDNS.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    protected void UDPClient(DatagramSocket socket, DatagramPacket inDataPacket) {
    }

    public static String toString(Record record) {
        if (record == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(record.getName());
        stringBuilder.append(" ");
        stringBuilder.append(record.getTTL());
        stringBuilder.append(" ");
        stringBuilder.append(DClass.string((int)record.getDClass()));
        stringBuilder.append(" ");
        stringBuilder.append(Type.string((int)record.getType()));
        String rdata = record.rdataToString();
        if (!rdata.equals("")) {
            stringBuilder.append(" ");
            stringBuilder.append(rdata);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage: EagleDNS [conf]");
            System.exit(0);
        }
        try {
            String configFilePath = args.length == 1 ? args[0] : "conf/config.xml";
            new EagleDNS(configFilePath);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    @Override
    public void run() {
        this.log.debug((Object)"Checking secondary zones...");
        for (CachedSecondaryZone cachedSecondaryZone : this.secondaryZoneMap.values()) {
            SecondaryZone secondaryZone = cachedSecondaryZone.getSecondaryZone();
            if (secondaryZone.getZoneCopy() != null && secondaryZone.getDownloaded() != null && System.currentTimeMillis() - secondaryZone.getDownloaded().getTime() <= secondaryZone.getZoneCopy().getSOA().getRefresh() * 1000L) continue;
            cachedSecondaryZone.update(this.axfrTimeout);
        }
    }

    protected ThreadPoolExecutor getTcpThreadPool() {
        return this.tcpThreadPool;
    }

    protected ThreadPoolExecutor getUdpThreadPool() {
        return this.udpThreadPool;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public TSIG getTSIG(Name name) {
        return this.TSIGs.get(name);
    }

    @Override
    public int primaryZoneCount() {
        return this.primaryZoneMap.size();
    }

    @Override
    public int secondaryZoneCount() {
        return this.secondaryZoneMap.size();
    }

    @Override
    public int getResolverCount() {
        return this.resolvers.size();
    }

    public int getActiveTCPThreadCount() {
        return this.tcpThreadPool.getActiveCount();
    }

    @Override
    public int getTCPThreadPoolMaxSize() {
        return this.tcpThreadPool.getMaximumPoolSize();
    }

    @Override
    public long getCompletedTCPQueryCount() {
        return this.tcpThreadPool.getCompletedTaskCount();
    }

    @Override
    public int getMaxActiveTCPThreadCount() {
        return this.tcpThreadPool.getLargestPoolSize();
    }

    @Override
    public int getActiveUDPThreadCount() {
        return this.udpThreadPool.getActiveCount();
    }

    @Override
    public int getUDPThreadPoolMaxSize() {
        return this.udpThreadPool.getMaximumPoolSize();
    }

    @Override
    public long getCompletedUDPQueryCount() {
        return this.udpThreadPool.getCompletedTaskCount();
    }

    @Override
    public int getMaxActiveUDPThreadCount() {
        return this.udpThreadPool.getLargestPoolSize();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public Plugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    @Override
    public Set<Map.Entry<String, Plugin>> getPlugins() {
        return this.plugins.entrySet();
    }

    @Override
    public Resolver getResolver(String name) {
        for (Map.Entry<String, Resolver> resolverEntry : this.resolvers) {
            if (!resolverEntry.getKey().equals(name)) continue;
            return resolverEntry.getValue();
        }
        return null;
    }

    @Override
    public List<Map.Entry<String, Resolver>> getResolvers() {
        return this.resolvers;
    }

    @Override
    public ZoneProvider getZoneProvider(String name) {
        return this.zoneProviders.get(name);
    }

    @Override
    public Set<Map.Entry<String, ZoneProvider>> getZoneProviders() {
        return this.zoneProviders.entrySet();
    }

    @Override
    public int getUDPThreadPoolMinSize() {
        return this.udpThreadPool.getCorePoolSize();
    }

    @Override
    public int getTCPThreadPoolMinSize() {
        return this.tcpThreadPool.getCorePoolSize();
    }

    protected void incrementRejectedTCPConnections() {
        this.rejectedTCPConnections.increment();
    }

    protected void incrementRejectedUDPConnections() {
        this.rejectedUDPConnections.increment();
    }

    @Override
    public long getRejectedTCPConnections() {
        return this.rejectedTCPConnections.getValue();
    }

    @Override
    public long getRejectedUDPConnections() {
        return this.rejectedUDPConnections.getValue();
    }
}

