/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns.zoneproviders.db.beans;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Zone;
import se.unlogic.eagledns.zoneproviders.db.beans.DBRecord;
import se.unlogic.standardutils.annotations.PopulateOnlyIfRequired;
import se.unlogic.standardutils.annotations.PopulateOnlyIfSet;
import se.unlogic.standardutils.annotations.RequiredIfNotSet;
import se.unlogic.standardutils.annotations.SplitOnLineBreak;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XMLElement
@Table(name="zones")
public class DBZone
implements Elementable,
Serializable {
    private static final long serialVersionUID = 1921566191357243531L;
    public static final Field RECORDS_RELATION = ReflectionUtils.getField(DBZone.class, "records");
    @DAOManaged(autoGenerated=true)
    @Key
    @XMLElement
    private Integer zoneID;
    @DAOManaged
    @XMLElement
    @OrderBy
    @WebPopulate(required=true, maxLength=255L)
    private String name;
    @DAOManaged
    @XMLElement
    @WebPopulate(required=true, maxLength=6L)
    private String dclass;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    @RequiredIfNotSet(paramNames={"secondary"}, paramValues={"true"})
    private Long ttl;
    @DAOManaged
    @XMLElement
    @WebPopulate(required=true, maxLength=255L)
    private String primaryDNS;
    @DAOManaged
    @XMLElement
    @WebPopulate(maxLength=255L)
    @RequiredIfNotSet(paramNames={"secondary"}, paramValues={"true"})
    @PopulateOnlyIfRequired
    private String adminEmail;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    @RequiredIfNotSet(paramNames={"secondary", "autoGenerateSerial"}, paramValues={"true"})
    @PopulateOnlyIfRequired
    private Long serial;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    @RequiredIfNotSet(paramNames={"secondary"}, paramValues={"true"})
    @PopulateOnlyIfRequired
    private Long refresh;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    @RequiredIfNotSet(paramNames={"secondary"}, paramValues={"true"})
    @PopulateOnlyIfRequired
    private Long retry;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    @RequiredIfNotSet(paramNames={"secondary"}, paramValues={"true"})
    @PopulateOnlyIfRequired
    private Long expire;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    @RequiredIfNotSet(paramNames={"secondary"}, paramValues={"true"})
    @PopulateOnlyIfRequired
    private Long minimum;
    @DAOManaged
    @OneToMany(autoAdd=true, autoGet=true, autoUpdate=true)
    @SimplifiedRelation(table="zonealiases", remoteKeyColumnName="zoneID", remoteValueColumnName="alias")
    @XMLElement(childName="alias")
    @WebPopulate
    @PopulateOnlyIfSet(paramNames={"secondary"}, paramValues={"false"})
    @SplitOnLineBreak
    private List<String> aliases;
    @DAOManaged
    @OneToMany
    @XMLElement
    private List<DBRecord> records;
    @DAOManaged
    @XMLElement
    @WebPopulate
    private boolean secondary;
    @DAOManaged
    @XMLElement
    @WebPopulate
    private boolean enabled;
    @DAOManaged
    @XMLElement
    private Timestamp downloaded;
    @DAOManaged
    @XMLElement
    @WebPopulate
    private boolean autoGenerateSerial;

    public DBZone() {
    }

    public DBZone(Zone zone, boolean secondary) {
        this.parse(zone, secondary);
    }

    public void parse(Zone zone, boolean secondary) {
        if (zone == null) {
            this.ttl = null;
            this.adminEmail = null;
            this.serial = null;
            this.refresh = null;
            this.retry = null;
            this.expire = null;
            this.minimum = null;
            this.records = null;
            this.downloaded = null;
        } else {
            SOARecord soaRecord = zone.getSOA();
            this.name = soaRecord.getName().toString();
            this.dclass = DClass.string((int)soaRecord.getDClass());
            this.ttl = soaRecord.getTTL();
            this.primaryDNS = soaRecord.getHost().toString();
            this.adminEmail = soaRecord.getAdmin().toString();
            this.serial = soaRecord.getSerial();
            this.refresh = soaRecord.getRefresh();
            this.retry = soaRecord.getRetry();
            this.expire = soaRecord.getExpire();
            this.minimum = soaRecord.getMinimum();
            this.secondary = secondary;
            if (secondary) {
                this.downloaded = new Timestamp(System.currentTimeMillis());
            }
            this.records = new ArrayList<DBRecord>();
            for (RRset rRset : zone) {
                Iterator rrSetIterator = rRset.rrs();
                while (rrSetIterator.hasNext()) {
                    Record record = (Record)rrSetIterator.next();
                    if (record.getType() == 6) continue;
                    this.records.add(new DBRecord(record, zone.getSOA().getName(), this.ttl));
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDclass() {
        return this.dclass;
    }

    public void setDclass(String dclass) {
        this.dclass = dclass;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public String getPrimaryDNS() {
        return this.primaryDNS;
    }

    public void setPrimaryDNS(String primaryDns) {
        this.primaryDNS = primaryDns;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public Long getSerial() {
        return this.serial;
    }

    public void setSerial(Long serial) {
        this.serial = serial;
    }

    public Long getRefresh() {
        return this.refresh;
    }

    public void setRefresh(Long refresh) {
        this.refresh = refresh;
    }

    public Long getRetry() {
        return this.retry;
    }

    public void setRetry(Long retry) {
        this.retry = retry;
    }

    public Long getExpire() {
        return this.expire;
    }

    public void setExpire(Long expire) {
        this.expire = expire;
    }

    public Long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Long minimum) {
        this.minimum = minimum;
    }

    public List<DBRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<DBRecord> records) {
        this.records = records;
    }

    public Integer getZoneID() {
        return this.zoneID;
    }

    public void setZoneID(Integer zoneID) {
        this.zoneID = zoneID;
    }

    @Override
    public Element toXML(Document doc) {
        return XMLGenerator.toXML(this, doc);
    }

    public List<Zone> toZones() throws IOException {
        Name primaryNS = Name.fromString((String)this.primaryDNS);
        Name zoneName = Name.fromString((String)this.name);
        SOARecord soaRecord = new SOARecord(zoneName, DClass.value((String)this.dclass), this.ttl.longValue(), primaryNS, Name.fromString((String)this.adminEmail), this.serial.longValue(), this.refresh.longValue(), this.retry.longValue(), this.expire.longValue(), this.minimum.longValue());
        Record[] recordArray = this.getRecordArray(zoneName, soaRecord);
        if (CollectionUtils.isEmpty(this.aliases)) {
            return Collections.singletonList(new Zone(zoneName, recordArray));
        }
        ArrayList<Zone> zones = new ArrayList<Zone>(this.aliases.size() + 1);
        zones.add(new Zone(zoneName, recordArray));
        for (String alias : this.aliases) {
            zoneName = Name.fromString((String)alias);
            soaRecord = new SOARecord(zoneName, DClass.value((String)this.dclass), this.ttl.longValue(), primaryNS, Name.fromString((String)this.adminEmail), this.serial.longValue(), this.refresh.longValue(), this.retry.longValue(), this.expire.longValue(), this.minimum.longValue());
            recordArray = this.getRecordArray(zoneName, soaRecord);
            zones.add(new Zone(zoneName, recordArray));
        }
        return zones;
    }

    public Zone toZone() throws IOException {
        Name primaryNS = Name.fromString((String)this.primaryDNS);
        Name zoneName = Name.fromString((String)this.name);
        SOARecord soaRecord = new SOARecord(zoneName, DClass.value((String)this.dclass), this.ttl.longValue(), primaryNS, Name.fromString((String)this.adminEmail), this.serial.longValue(), this.refresh.longValue(), this.retry.longValue(), this.expire.longValue(), this.minimum.longValue());
        return new Zone(zoneName, this.getRecordArray(zoneName, soaRecord));
    }

    private Record[] getRecordArray(Name zoneName, SOARecord soaRecord) throws TextParseException, IOException {
        int recordCount = this.records != null ? 1 + this.records.size() : 1;
        Record[] recordArray = new Record[recordCount];
        recordArray[0] = soaRecord;
        if (this.records != null) {
            int pos = 1;
            for (DBRecord record : this.records) {
                recordArray[pos] = record.getRecord(this.ttl, zoneName);
                ++pos;
            }
        }
        return recordArray;
    }

    public boolean isSecondary() {
        return this.secondary;
    }

    public void setSecondary(boolean secondary) {
        this.secondary = secondary;
    }

    public String toString() {
        return String.valueOf(this.name) + " (ID: " + this.zoneID + ")";
    }

    public Timestamp getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(Timestamp zoneDownloaded) {
        this.downloaded = zoneDownloaded;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAutoGenerateSerial(boolean autoGenerateSerial) {
        this.autoGenerateSerial = autoGenerateSerial;
    }

    public boolean isAutoGenerateSerial() {
        return this.autoGenerateSerial;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

