/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import se.unlogic.standardutils.annotations.UnsupportedFieldTypeException;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.ManyToOneRelation;
import se.unlogic.standardutils.dao.MethodBasedResultSetPopulator;
import se.unlogic.standardutils.dao.PreparedStatementQueryMethods;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.ResultSetMethods;
import se.unlogic.standardutils.dao.TypeBasedResultSetPopulator;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.BeanStringPopulatorRegistery;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManyToOneRelation<LocalType, RemoteType, RemoteKeyType>
implements ManyToOneRelation<LocalType, RemoteType, RemoteKeyType> {
    private final String columnName;
    private final Field field;
    private QueryParameterPopulator<RemoteKeyType> queryParameterPopulator;
    private Method queryMethod;
    private final BeanResultSetPopulator<RemoteKeyType> remoteKeyPopulator;
    private final Field remoteKeyField;
    private final AnnotatedDAOFactory daoFactory;
    private AnnotatedDAO<RemoteType> annotatedDAO;
    private QueryParameterFactory<RemoteType, RemoteKeyType> queryParameterFactory;
    private final Class<RemoteType> remoteClass;
    private final Class<RemoteKeyType> remoteRemoteKeyClass;
    private boolean initialized;

    public DefaultManyToOneRelation(Class<LocalType> beanClass, Class<RemoteType> remoteClass, Class<RemoteKeyType> remoteKeyClass, Field field, Field remoteKeyField, DAOManaged daoManaged, AnnotatedDAOFactory daoFactory) {
        this.remoteClass = remoteClass;
        this.remoteRemoteKeyClass = remoteKeyClass;
        this.field = field;
        this.remoteKeyField = remoteKeyField;
        this.daoFactory = daoFactory;
        this.columnName = !StringUtils.isEmpty(daoManaged.columnName()) ? daoManaged.columnName() : field.getName();
        ReflectionUtils.fixFieldAccess(remoteKeyField);
        Method resultSetMethod = ResultSetMethods.getColumnNameMethod(remoteKeyClass);
        if (resultSetMethod != null) {
            this.remoteKeyPopulator = new MethodBasedResultSetPopulator<RemoteKeyType>(resultSetMethod, this.columnName);
        } else {
            BeanStringPopulator<RemoteKeyType> typePopulator = BeanStringPopulatorRegistery.getBeanStringPopulator(remoteKeyClass);
            if (typePopulator != null) {
                this.remoteKeyPopulator = new TypeBasedResultSetPopulator<RemoteKeyType>(typePopulator, this.columnName);
            } else {
                throw new UnsupportedFieldTypeException("Unable to find resultset method or type populator for field " + remoteKeyField.getName() + " in " + remoteClass + " when creating many to one relation for field " + field.getName() + " in " + beanClass, field, ManyToOne.class, beanClass);
            }
        }
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public QueryParameterPopulator<RemoteKeyType> getQueryParameterPopulator() {
        if (this.queryParameterPopulator == null && this.queryMethod == null) {
            if (!this.initialized) {
                this.init();
            }
            this.queryParameterPopulator = this.annotatedDAO.getQueryParameterPopulator(this.remoteRemoteKeyClass);
        }
        return this.queryParameterPopulator;
    }

    @Override
    public Method getQueryMethod() {
        if (this.queryMethod == null) {
            this.queryMethod = PreparedStatementQueryMethods.getObjectQueryMethod();
        }
        return this.queryMethod;
    }

    @Override
    public RemoteKeyType getBeanValue(LocalType bean) {
        Object subBean;
        block4: {
            subBean = this.field.get(bean);
            if (subBean != null) break block4;
            return null;
        }
        try {
            return (RemoteKeyType)this.remoteKeyField.get(subBean);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RemoteKeyType getParamValue(Object bean) {
        block4: {
            if (bean != null) break block4;
            return null;
        }
        try {
            return (RemoteKeyType)this.remoteKeyField.get(bean);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void getRemoteValue(LocalType bean, ResultSet resultSet, Connection connection, RelationQuery relationQuery) throws SQLException {
        try {
            RemoteKeyType keyValue;
            if (!this.initialized) {
                this.init();
            }
            if ((keyValue = this.remoteKeyPopulator.populate(resultSet)) != null) {
                HighLevelQuery<RemoteType> query = new HighLevelQuery<RemoteType>();
                query.addParameter(this.queryParameterFactory.getParameter(keyValue));
                if (relationQuery != null) {
                    query.disableAutoRelations(relationQuery.isDisableAutoRelations());
                }
                query.addRelations(relationQuery);
                RemoteType remoteBeanInstance = this.annotatedDAO.get(query, connection);
                this.getField().set(bean, remoteBeanInstance);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            Object remoteBean = this.field.get(bean);
            if (remoteBean != null) {
                this.annotatedDAO.add(remoteBean, connection, relationQuery);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            Object remoteBean = this.field.get(bean);
            if (remoteBean != null) {
                this.annotatedDAO.addOrUpdate(remoteBean, connection, relationQuery);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        this.annotatedDAO = this.daoFactory.getDAO(this.remoteClass);
        this.queryParameterFactory = this.annotatedDAO.getParamFactory(this.remoteKeyField, this.remoteRemoteKeyClass);
        this.initialized = true;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Field getBeanField() {
        return this.field;
    }

    @Override
    public Class<RemoteType> getParamType() {
        return this.remoteClass;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    public static <LT, RT, RKT> DefaultManyToOneRelation<LT, RT, RKT> getGenericInstance(Class<LT> beanClass, Class<RT> remoteClass, Class<RKT> remoteKeyClass, Field field, Field remoteField, DAOManaged daoManaged, AnnotatedDAOFactory daoFactory) {
        return new DefaultManyToOneRelation<LT, RT, RKT>(beanClass, remoteClass, remoteKeyClass, field, remoteField, daoManaged, daoFactory);
    }
}

