/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao.querys;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.standardutils.dao.querys.GeneratedKeyCollector;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.db.DBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateQuery
extends PreparedStatementQuery {
    private Integer affectedRows;

    public UpdateQuery(Connection connection, boolean closeConnectionOnExit, String query) throws SQLException {
        super(connection, closeConnectionOnExit, query);
    }

    public UpdateQuery(DataSource dataSource, boolean closeConnectionOnExit, String query) throws SQLException {
        super(dataSource, closeConnectionOnExit, query);
    }

    public void executeUpdate() throws SQLException {
        ResultSet rs = null;
        try {
            this.affectedRows = this.pstmt.executeUpdate();
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePreparedStatement(this.pstmt);
            if (this.closeConnectionOnExit) {
                DBUtils.closeConnection(this.connection);
            }
            this.closed = true;
        }
    }

    public void executeUpdate(List<GeneratedKeyCollector> keyCollectors) throws SQLException {
        ResultSet rs = null;
        try {
            this.affectedRows = this.pstmt.executeUpdate();
            if (this.affectedRows > 0 && (rs = this.pstmt.getGeneratedKeys()).next()) {
                for (GeneratedKeyCollector keyCollector : keyCollectors) {
                    keyCollector.collect(rs);
                }
            }
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePreparedStatement(this.pstmt);
            if (this.closeConnectionOnExit) {
                DBUtils.closeConnection(this.connection);
            }
            this.closed = true;
        }
    }

    public void executeUpdate(GeneratedKeyCollector ... keyCollectors) throws SQLException {
        this.executeUpdate(Arrays.asList(keyCollectors));
    }

    public Integer getAffectedRows() {
        return this.affectedRows;
    }
}

