/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.unlogic.standardutils.json.JsonLeaf;
import se.unlogic.standardutils.json.JsonNode;

public class JsonObject
implements JsonNode {
    private static final long serialVersionUID = -4958874287623042122L;
    private final Map<String, JsonNode> fields = new HashMap<String, JsonNode>();

    public String toJson() {
        return this.toJson(new StringBuilder());
    }

    public String toJson(StringBuilder stringBuilder) {
        stringBuilder.append("{");
        Iterator<Map.Entry<String, JsonNode>> iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> field = iterator.next();
            stringBuilder.append("\"");
            stringBuilder.append(field.getKey());
            stringBuilder.append("\"");
            stringBuilder.append(":");
            field.getValue().toJson(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void putField(String key, JsonNode value) {
        this.fields.put(key, value);
    }

    public void putField(String key, String value) {
        this.fields.put(key, new JsonLeaf(value));
    }

    public void removeField(String key) {
        this.fields.remove(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
    }
}

