/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.validation.StringFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeStampPopulator
extends BaseStringPopulator<Timestamp>
implements BeanResultSetPopulator<Timestamp> {
    private final DateFormat dateFormat;
    private static final TimeStampPopulator POPULATOR = new TimeStampPopulator();

    public TimeStampPopulator() {
        this.dateFormat = null;
    }

    public TimeStampPopulator(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimeStampPopulator(String populatorID, DateFormat dateFormat) {
        super(populatorID);
        this.dateFormat = dateFormat;
    }

    public TimeStampPopulator(String populatorID, DateFormat dateFormat, StringFormatValidator formatValidator) {
        super(populatorID, formatValidator);
        this.dateFormat = dateFormat;
    }

    @Override
    public Class<? extends Timestamp> getType() {
        return Timestamp.class;
    }

    @Override
    public Timestamp getValue(String value) {
        try {
            return new Timestamp(this.dateFormat.parse(value).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        return DateUtils.isValidDate(this.dateFormat, value);
    }

    public static TimeStampPopulator getPopulator() {
        return POPULATOR;
    }

    @Override
    public Timestamp populate(ResultSet rs) throws SQLException {
        return rs.getTimestamp(1);
    }
}

