/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.time;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUtils {
    public static SimpleDateFormat HOUR_FORMATTER = new SimpleDateFormat("HH");
    public static SimpleDateFormat MINUTE_FORMATTER = new SimpleDateFormat("mm");
    public static SimpleDateFormat SECOND_FORMATTER = new SimpleDateFormat("ss");
    public static SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm");

    public static String secondsToString(long time) {
        return TimeUtils.millisecondsToString(time * 1000L);
    }

    public static String millisecondsToString(long time) {
        int milliseconds = (int)(time % 1000L);
        int seconds = (int)(time / 1000L % 60L);
        int minutes = (int)(time / 60000L % 60L);
        int hours = (int)(time / 3600000L % 24L);
        String millisecondsStr = String.valueOf(milliseconds < 10 ? "00" : (milliseconds < 100 ? "0" : "")) + milliseconds;
        String secondsStr = String.valueOf(seconds < 10 ? "0" : "") + seconds;
        String minutesStr = String.valueOf(minutes < 10 ? "0" : "") + minutes;
        String hoursStr = String.valueOf(hours < 10 ? "0" : "") + hours;
        return new String(String.valueOf(hoursStr) + ":" + minutesStr + ":" + secondsStr + "." + millisecondsStr);
    }

    public static int getMinutes(long time) {
        return Integer.valueOf(MINUTE_FORMATTER.format(new Date(time)));
    }

    public static int getSeconds(long time) {
        return Integer.valueOf(SECOND_FORMATTER.format(new Date(time)));
    }

    public static int getHour(long time) {
        return Integer.valueOf(HOUR_FORMATTER.format(new Date(time)));
    }

    public static String hourAndMinutesToString(int hours, int minutes) {
        String minutesStr = String.valueOf(minutes < 10 ? "0" : "") + minutes;
        String hoursStr = String.valueOf(hours < 10 ? "0" : "") + hours;
        return new String(String.valueOf(hoursStr) + ":" + minutesStr);
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }
}

