/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.Resolver;

public class ListResolversByFunctionIterable
implements SdkIterable<ListResolversByFunctionResponse> {
    private final AppSyncClient client;
    private final ListResolversByFunctionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolversByFunctionIterable(AppSyncClient client, ListResolversByFunctionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolversByFunctionResponseFetcher();
    }

    public Iterator<ListResolversByFunctionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Resolver> resolvers() {
        Function<ListResolversByFunctionResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolvers() != null) {
                return response.resolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolversByFunctionResponseFetcher
    implements SyncPageFetcher<ListResolversByFunctionResponse> {
        private ListResolversByFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListResolversByFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolversByFunctionResponse nextPage(ListResolversByFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListResolversByFunctionIterable.this.client.listResolversByFunction(ListResolversByFunctionIterable.this.firstRequest);
            }
            return ListResolversByFunctionIterable.this.client.listResolversByFunction((ListResolversByFunctionRequest)((Object)ListResolversByFunctionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

