/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyDefinitionRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionRule> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AutomatedReasoningPolicyDefinitionRule.getter(AutomatedReasoningPolicyDefinitionRule::id)).setter(AutomatedReasoningPolicyDefinitionRule.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(AutomatedReasoningPolicyDefinitionRule.getter(AutomatedReasoningPolicyDefinitionRule::expression)).setter(AutomatedReasoningPolicyDefinitionRule.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<String> ALTERNATE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alternateExpression").getter(AutomatedReasoningPolicyDefinitionRule.getter(AutomatedReasoningPolicyDefinitionRule::alternateExpression)).setter(AutomatedReasoningPolicyDefinitionRule.setter(Builder::alternateExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXPRESSION_FIELD, ALTERNATE_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyDefinitionRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String expression;
    private final String alternateExpression;

    private AutomatedReasoningPolicyDefinitionRule(BuilderImpl builder) {
        this.id = builder.id;
        this.expression = builder.expression;
        this.alternateExpression = builder.alternateExpression;
    }

    public final String id() {
        return this.id;
    }

    public final String expression() {
        return this.expression;
    }

    public final String alternateExpression() {
        return this.alternateExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinitionRule)) {
            return false;
        }
        AutomatedReasoningPolicyDefinitionRule other = (AutomatedReasoningPolicyDefinitionRule)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.alternateExpression(), other.alternateExpression());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyDefinitionRule").add("Id", (Object)this.id()).add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("AlternateExpression", (Object)(this.alternateExpression() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "alternateExpression": {
                return Optional.ofNullable(clazz.cast(this.alternateExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("id", ID_FIELD);
        map.put("expression", EXPRESSION_FIELD);
        map.put("alternateExpression", ALTERNATE_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinitionRule, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinitionRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String expression;
        private String alternateExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinitionRule model) {
            this.id(model.id);
            this.expression(model.expression);
            this.alternateExpression(model.alternateExpression);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getAlternateExpression() {
            return this.alternateExpression;
        }

        public final void setAlternateExpression(String alternateExpression) {
            this.alternateExpression = alternateExpression;
        }

        @Override
        public final Builder alternateExpression(String alternateExpression) {
            this.alternateExpression = alternateExpression;
            return this;
        }

        public AutomatedReasoningPolicyDefinitionRule build() {
            return new AutomatedReasoningPolicyDefinitionRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionRule> {
        public Builder id(String var1);

        public Builder expression(String var1);

        public Builder alternateExpression(String var1);
    }
}

