/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.NeptuneAnalyticsFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NeptuneAnalyticsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NeptuneAnalyticsConfiguration> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphArn").getter(NeptuneAnalyticsConfiguration.getter(NeptuneAnalyticsConfiguration::graphArn)).setter(NeptuneAnalyticsConfiguration.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphArn").build()}).build();
    private static final SdkField<NeptuneAnalyticsFieldMapping> FIELD_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldMapping").getter(NeptuneAnalyticsConfiguration.getter(NeptuneAnalyticsConfiguration::fieldMapping)).setter(NeptuneAnalyticsConfiguration.setter(Builder::fieldMapping)).constructor(NeptuneAnalyticsFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, FIELD_MAPPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NeptuneAnalyticsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String graphArn;
    private final NeptuneAnalyticsFieldMapping fieldMapping;

    private NeptuneAnalyticsConfiguration(BuilderImpl builder) {
        this.graphArn = builder.graphArn;
        this.fieldMapping = builder.fieldMapping;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final NeptuneAnalyticsFieldMapping fieldMapping() {
        return this.fieldMapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMapping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeptuneAnalyticsConfiguration)) {
            return false;
        }
        NeptuneAnalyticsConfiguration other = (NeptuneAnalyticsConfiguration)obj;
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.fieldMapping(), other.fieldMapping());
    }

    public final String toString() {
        return ToString.builder((String)"NeptuneAnalyticsConfiguration").add("GraphArn", (Object)(this.graphArn() == null ? null : "*** Sensitive Data Redacted ***")).add("FieldMapping", (Object)this.fieldMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "fieldMapping": {
                return Optional.ofNullable(clazz.cast(this.fieldMapping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphArn", GRAPH_ARN_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeptuneAnalyticsConfiguration, T> g) {
        return obj -> g.apply((NeptuneAnalyticsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String graphArn;
        private NeptuneAnalyticsFieldMapping fieldMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneAnalyticsConfiguration model) {
            this.graphArn(model.graphArn);
            this.fieldMapping(model.fieldMapping);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final NeptuneAnalyticsFieldMapping.Builder getFieldMapping() {
            return this.fieldMapping != null ? this.fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(NeptuneAnalyticsFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(NeptuneAnalyticsFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public NeptuneAnalyticsConfiguration build() {
            return new NeptuneAnalyticsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NeptuneAnalyticsConfiguration> {
        public Builder graphArn(String var1);

        public Builder fieldMapping(NeptuneAnalyticsFieldMapping var1);

        default public Builder fieldMapping(Consumer<NeptuneAnalyticsFieldMapping.Builder> fieldMapping) {
            return this.fieldMapping((NeptuneAnalyticsFieldMapping)((NeptuneAnalyticsFieldMapping.Builder)NeptuneAnalyticsFieldMapping.builder().applyMutation(fieldMapping)).build());
        }
    }
}

