/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentKnowledgeBaseRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateAgentKnowledgeBaseRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(UpdateAgentKnowledgeBaseRequest.getter(UpdateAgentKnowledgeBaseRequest::agentId)).setter(UpdateAgentKnowledgeBaseRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(UpdateAgentKnowledgeBaseRequest.getter(UpdateAgentKnowledgeBaseRequest::agentVersion)).setter(UpdateAgentKnowledgeBaseRequest.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(UpdateAgentKnowledgeBaseRequest.getter(UpdateAgentKnowledgeBaseRequest::knowledgeBaseId)).setter(UpdateAgentKnowledgeBaseRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAgentKnowledgeBaseRequest.getter(UpdateAgentKnowledgeBaseRequest::description)).setter(UpdateAgentKnowledgeBaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseState").getter(UpdateAgentKnowledgeBaseRequest.getter(UpdateAgentKnowledgeBaseRequest::knowledgeBaseStateAsString)).setter(UpdateAgentKnowledgeBaseRequest.setter(Builder::knowledgeBaseState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_VERSION_FIELD, KNOWLEDGE_BASE_ID_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAgentKnowledgeBaseRequest.memberNameToFieldInitializer();
    private final String agentId;
    private final String agentVersion;
    private final String knowledgeBaseId;
    private final String description;
    private final String knowledgeBaseState;

    private UpdateAgentKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.description = builder.description;
        this.knowledgeBaseState = builder.knowledgeBaseState;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String description() {
        return this.description;
    }

    public final KnowledgeBaseState knowledgeBaseState() {
        return KnowledgeBaseState.fromValue(this.knowledgeBaseState);
    }

    public final String knowledgeBaseStateAsString() {
        return this.knowledgeBaseState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentKnowledgeBaseRequest)) {
            return false;
        }
        UpdateAgentKnowledgeBaseRequest other = (UpdateAgentKnowledgeBaseRequest)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseStateAsString(), other.knowledgeBaseStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentKnowledgeBaseRequest").add("AgentId", (Object)this.agentId()).add("AgentVersion", (Object)this.agentVersion()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Description", (Object)this.description()).add("KnowledgeBaseState", (Object)this.knowledgeBaseStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseState": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseState", KNOWLEDGE_BASE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((UpdateAgentKnowledgeBaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String agentId;
        private String agentVersion;
        private String knowledgeBaseId;
        private String description;
        private String knowledgeBaseState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentKnowledgeBaseRequest model) {
            super(model);
            this.agentId(model.agentId);
            this.agentVersion(model.agentVersion);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.description(model.description);
            this.knowledgeBaseState(model.knowledgeBaseState);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseState() {
            return this.knowledgeBaseState;
        }

        public final void setKnowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
        }

        @Override
        public final Builder knowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
            return this;
        }

        @Override
        public final Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState) {
            this.knowledgeBaseState(knowledgeBaseState == null ? null : knowledgeBaseState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentKnowledgeBaseRequest build() {
            return new UpdateAgentKnowledgeBaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentKnowledgeBaseRequest> {
        public Builder agentId(String var1);

        public Builder agentVersion(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder description(String var1);

        public Builder knowledgeBaseState(String var1);

        public Builder knowledgeBaseState(KnowledgeBaseState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

