/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.Metadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailureTrace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailureTrace> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(FailureTrace.getter(FailureTrace::traceId)).setter(FailureTrace.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(FailureTrace.getter(FailureTrace::failureReason)).setter(FailureTrace.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Integer> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureCode").getter(FailureTrace.getter(FailureTrace::failureCode)).setter(FailureTrace.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<Metadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(FailureTrace.getter(FailureTrace::metadata)).setter(FailureTrace.setter(Builder::metadata)).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FailureTrace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String traceId;
    private final String failureReason;
    private final Integer failureCode;
    private final Metadata metadata;

    private FailureTrace(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.metadata = builder.metadata;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Integer failureCode() {
        return this.failureCode;
    }

    public final Metadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureTrace)) {
            return false;
        }
        FailureTrace other = (FailureTrace)obj;
        return Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"FailureTrace").add("TraceId", (Object)this.traceId()).add("FailureReason", (Object)(this.failureReason() == null ? null : "*** Sensitive Data Redacted ***")).add("FailureCode", (Object)this.failureCode()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("traceId", TRACE_ID_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailureTrace, T> g) {
        return obj -> g.apply((FailureTrace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String traceId;
        private String failureReason;
        private Integer failureCode;
        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureTrace model) {
            this.traceId(model.traceId);
            this.failureReason(model.failureReason);
            this.failureCode(model.failureCode);
            this.metadata(model.metadata);
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Integer getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(Integer failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(Integer failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public FailureTrace build() {
            return new FailureTrace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailureTrace> {
        public Builder traceId(String var1);

        public Builder failureReason(String var1);

        public Builder failureCode(Integer var1);

        public Builder metadata(Metadata var1);

        default public Builder metadata(Consumer<Metadata.Builder> metadata) {
            return this.metadata((Metadata)((Metadata.Builder)Metadata.builder().applyMutation(metadata)).build());
        }
    }
}

