/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlowErrorCode {
    VALIDATION("VALIDATION"),
    INTERNAL_SERVER("INTERNAL_SERVER"),
    NODE_EXECUTION_FAILED("NODE_EXECUTION_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowErrorCode> VALUE_MAP;
    private final String value;

    private FlowErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlowErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlowErrorCode> knownValues() {
        EnumSet<FlowErrorCode> knownValues = EnumSet.allOf(FlowErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlowErrorCode.class, FlowErrorCode::toString);
    }
}

