/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowOutputField;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowOutputFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowExecutionOutputEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowExecutionOutputEvent> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(FlowExecutionOutputEvent.getter(FlowExecutionOutputEvent::nodeName)).setter(FlowExecutionOutputEvent.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(FlowExecutionOutputEvent.getter(FlowExecutionOutputEvent::timestamp)).setter(FlowExecutionOutputEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<FlowOutputField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(FlowExecutionOutputEvent.getter(FlowExecutionOutputEvent::fields)).setter(FlowExecutionOutputEvent.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowOutputField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD, TIMESTAMP_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowExecutionOutputEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeName;
    private final Instant timestamp;
    private final List<FlowOutputField> fields;

    private FlowExecutionOutputEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
        this.fields = builder.fields;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<FlowOutputField> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionOutputEvent)) {
            return false;
        }
        FlowExecutionOutputEvent other = (FlowExecutionOutputEvent)obj;
        return Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.timestamp(), other.timestamp()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"FlowExecutionOutputEvent").add("NodeName", (Object)this.nodeName()).add("Timestamp", (Object)this.timestamp()).add("Fields", (Object)(this.fields() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionOutputEvent, T> g) {
        return obj -> g.apply((FlowExecutionOutputEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeName;
        private Instant timestamp;
        private List<FlowOutputField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionOutputEvent model) {
            this.nodeName(model.nodeName);
            this.timestamp(model.timestamp);
            this.fields(model.fields);
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<FlowOutputField.Builder> getFields() {
            List<FlowOutputField.Builder> result = FlowOutputFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FlowOutputField.BuilderImpl> fields) {
            this.fields = FlowOutputFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FlowOutputField> fields) {
            this.fields = FlowOutputFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FlowOutputField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FlowOutputField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (FlowOutputField)((FlowOutputField.Builder)FlowOutputField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FlowExecutionOutputEvent build() {
            return new FlowExecutionOutputEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowExecutionOutputEvent> {
        public Builder nodeName(String var1);

        public Builder timestamp(Instant var1);

        public Builder fields(Collection<FlowOutputField> var1);

        public Builder fields(FlowOutputField ... var1);

        public Builder fields(Consumer<FlowOutputField.Builder> ... var1);
    }
}

