/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowExecutionSummary> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(FlowExecutionSummary.getter(FlowExecutionSummary::executionArn)).setter(FlowExecutionSummary.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(FlowExecutionSummary.getter(FlowExecutionSummary::flowAliasIdentifier)).setter(FlowExecutionSummary.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(FlowExecutionSummary.getter(FlowExecutionSummary::flowIdentifier)).setter(FlowExecutionSummary.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowVersion").getter(FlowExecutionSummary.getter(FlowExecutionSummary::flowVersion)).setter(FlowExecutionSummary.setter(Builder::flowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FlowExecutionSummary.getter(FlowExecutionSummary::statusAsString)).setter(FlowExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FlowExecutionSummary.getter(FlowExecutionSummary::createdAt)).setter(FlowExecutionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(FlowExecutionSummary.getter(FlowExecutionSummary::endedAt)).setter(FlowExecutionSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD, FLOW_VERSION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, ENDED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionArn;
    private final String flowAliasIdentifier;
    private final String flowIdentifier;
    private final String flowVersion;
    private final String status;
    private final Instant createdAt;
    private final Instant endedAt;

    private FlowExecutionSummary(BuilderImpl builder) {
        this.executionArn = builder.executionArn;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.flowVersion = builder.flowVersion;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.endedAt = builder.endedAt;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String flowVersion() {
        return this.flowVersion;
    }

    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionSummary)) {
            return false;
        }
        FlowExecutionSummary other = (FlowExecutionSummary)obj;
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.flowVersion(), other.flowVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.endedAt(), other.endedAt());
    }

    public final String toString() {
        return ToString.builder((String)"FlowExecutionSummary").add("ExecutionArn", (Object)this.executionArn()).add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("FlowVersion", (Object)this.flowVersion()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("EndedAt", (Object)this.endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "flowVersion": {
                return Optional.ofNullable(clazz.cast(this.flowVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowVersion", FLOW_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionSummary, T> g) {
        return obj -> g.apply((FlowExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionArn;
        private String flowAliasIdentifier;
        private String flowIdentifier;
        private String flowVersion;
        private String status;
        private Instant createdAt;
        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionSummary model) {
            this.executionArn(model.executionArn);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.flowIdentifier(model.flowIdentifier);
            this.flowVersion(model.flowVersion);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.endedAt(model.endedAt);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowVersion() {
            return this.flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public FlowExecutionSummary build() {
            return new FlowExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowExecutionSummary> {
        public Builder executionArn(String var1);

        public Builder flowAliasIdentifier(String var1);

        public Builder flowIdentifier(String var1);

        public Builder flowVersion(String var1);

        public Builder status(String var1);

        public Builder status(FlowExecutionStatus var1);

        public Builder createdAt(Instant var1);

        public Builder endedAt(Instant var1);
    }
}

