/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowNodeIODataType;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputContent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputNext;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputNextListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowTraceNodeOutputField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowTraceNodeOutputField> {
    private static final SdkField<String> NODE_OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeOutputName").getter(FlowTraceNodeOutputField.getter(FlowTraceNodeOutputField::nodeOutputName)).setter(FlowTraceNodeOutputField.setter(Builder::nodeOutputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputName").build()}).build();
    private static final SdkField<FlowTraceNodeOutputContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(FlowTraceNodeOutputField.getter(FlowTraceNodeOutputField::content)).setter(FlowTraceNodeOutputField.setter(Builder::content)).constructor(FlowTraceNodeOutputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<List<FlowTraceNodeOutputNext>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(FlowTraceNodeOutputField.getter(FlowTraceNodeOutputField::next)).setter(FlowTraceNodeOutputField.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowTraceNodeOutputNext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FlowTraceNodeOutputField.getter(FlowTraceNodeOutputField::typeAsString)).setter(FlowTraceNodeOutputField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_OUTPUT_NAME_FIELD, CONTENT_FIELD, NEXT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowTraceNodeOutputField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeOutputName;
    private final FlowTraceNodeOutputContent content;
    private final List<FlowTraceNodeOutputNext> next;
    private final String type;

    private FlowTraceNodeOutputField(BuilderImpl builder) {
        this.nodeOutputName = builder.nodeOutputName;
        this.content = builder.content;
        this.next = builder.next;
        this.type = builder.type;
    }

    public final String nodeOutputName() {
        return this.nodeOutputName;
    }

    public final FlowTraceNodeOutputContent content() {
        return this.content;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<FlowTraceNodeOutputNext> next() {
        return this.next;
    }

    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeOutputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeOutputField)) {
            return false;
        }
        FlowTraceNodeOutputField other = (FlowTraceNodeOutputField)obj;
        return Objects.equals(this.nodeOutputName(), other.nodeOutputName()) && Objects.equals(this.content(), other.content()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowTraceNodeOutputField").add("NodeOutputName", (Object)this.nodeOutputName()).add("Content", (Object)this.content()).add("Next", (Object)(this.next() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeOutputName": {
                return Optional.ofNullable(clazz.cast(this.nodeOutputName()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeOutputName", NODE_OUTPUT_NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeOutputField, T> g) {
        return obj -> g.apply((FlowTraceNodeOutputField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeOutputName;
        private FlowTraceNodeOutputContent content;
        private List<FlowTraceNodeOutputNext> next = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeOutputField model) {
            this.nodeOutputName(model.nodeOutputName);
            this.content(model.content);
            this.next(model.next);
            this.type(model.type);
        }

        public final String getNodeOutputName() {
            return this.nodeOutputName;
        }

        public final void setNodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
        }

        @Override
        public final Builder nodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
            return this;
        }

        public final FlowTraceNodeOutputContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(FlowTraceNodeOutputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowTraceNodeOutputContent content) {
            this.content = content;
            return this;
        }

        public final List<FlowTraceNodeOutputNext.Builder> getNext() {
            List<FlowTraceNodeOutputNext.Builder> result = FlowTraceNodeOutputNextListCopier.copyToBuilder(this.next);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNext(Collection<FlowTraceNodeOutputNext.BuilderImpl> next) {
            this.next = FlowTraceNodeOutputNextListCopier.copyFromBuilder(next);
        }

        @Override
        public final Builder next(Collection<FlowTraceNodeOutputNext> next) {
            this.next = FlowTraceNodeOutputNextListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(FlowTraceNodeOutputNext ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(Consumer<FlowTraceNodeOutputNext.Builder> ... next) {
            this.next(Stream.of(next).map(c -> (FlowTraceNodeOutputNext)((FlowTraceNodeOutputNext.Builder)FlowTraceNodeOutputNext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FlowTraceNodeOutputField build() {
            return new FlowTraceNodeOutputField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowTraceNodeOutputField> {
        public Builder nodeOutputName(String var1);

        public Builder content(FlowTraceNodeOutputContent var1);

        default public Builder content(Consumer<FlowTraceNodeOutputContent.Builder> content) {
            return this.content((FlowTraceNodeOutputContent)((FlowTraceNodeOutputContent.Builder)FlowTraceNodeOutputContent.builder().applyMutation(content)).build());
        }

        public Builder next(Collection<FlowTraceNodeOutputNext> var1);

        public Builder next(FlowTraceNodeOutputNext ... var1);

        public Builder next(Consumer<FlowTraceNodeOutputNext.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(FlowNodeIODataType var1);
    }
}

