/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.AdditionalModelRequestFieldsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InferenceConfig;
import software.amazon.awssdk.services.bedrockagentruntime.model.PerformanceConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptTemplate;
import software.amazon.awssdk.services.bedrockagentruntime.model.QueryTransformationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrchestrationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrchestrationConfiguration> {
    private static final SdkField<PromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptTemplate").getter(OrchestrationConfiguration.getter(OrchestrationConfiguration::promptTemplate)).setter(OrchestrationConfiguration.setter(Builder::promptTemplate)).constructor(PromptTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()}).build();
    private static final SdkField<InferenceConfig> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(OrchestrationConfiguration.getter(OrchestrationConfiguration::inferenceConfig)).setter(OrchestrationConfiguration.setter(Builder::inferenceConfig)).constructor(InferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalModelRequestFields").getter(OrchestrationConfiguration.getter(OrchestrationConfiguration::additionalModelRequestFields)).setter(OrchestrationConfiguration.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<QueryTransformationConfiguration> QUERY_TRANSFORMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryTransformationConfiguration").getter(OrchestrationConfiguration.getter(OrchestrationConfiguration::queryTransformationConfiguration)).setter(OrchestrationConfiguration.setter(Builder::queryTransformationConfiguration)).constructor(QueryTransformationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryTransformationConfiguration").build()}).build();
    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performanceConfig").getter(OrchestrationConfiguration.getter(OrchestrationConfiguration::performanceConfig)).setter(OrchestrationConfiguration.setter(Builder::performanceConfig)).constructor(PerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TEMPLATE_FIELD, INFERENCE_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, QUERY_TRANSFORMATION_CONFIGURATION_FIELD, PERFORMANCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrchestrationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PromptTemplate promptTemplate;
    private final InferenceConfig inferenceConfig;
    private final Map<String, Document> additionalModelRequestFields;
    private final QueryTransformationConfiguration queryTransformationConfiguration;
    private final PerformanceConfiguration performanceConfig;

    private OrchestrationConfiguration(BuilderImpl builder) {
        this.promptTemplate = builder.promptTemplate;
        this.inferenceConfig = builder.inferenceConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.queryTransformationConfiguration = builder.queryTransformationConfiguration;
        this.performanceConfig = builder.performanceConfig;
    }

    public final PromptTemplate promptTemplate() {
        return this.promptTemplate;
    }

    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final boolean hasAdditionalModelRequestFields() {
        return this.additionalModelRequestFields != null && !(this.additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final QueryTransformationConfiguration queryTransformationConfiguration() {
        return this.queryTransformationConfiguration;
    }

    public final PerformanceConfiguration performanceConfig() {
        return this.performanceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryTransformationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationConfiguration)) {
            return false;
        }
        OrchestrationConfiguration other = (OrchestrationConfiguration)obj;
        return Objects.equals(this.promptTemplate(), other.promptTemplate()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && this.hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields() && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && Objects.equals(this.queryTransformationConfiguration(), other.queryTransformationConfiguration()) && Objects.equals(this.performanceConfig(), other.performanceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"OrchestrationConfiguration").add("PromptTemplate", (Object)this.promptTemplate()).add("InferenceConfig", (Object)this.inferenceConfig()).add("AdditionalModelRequestFields", this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null).add("QueryTransformationConfiguration", (Object)this.queryTransformationConfiguration()).add("PerformanceConfig", (Object)this.performanceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptTemplate": {
                return Optional.ofNullable(clazz.cast(this.promptTemplate()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "queryTransformationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.queryTransformationConfiguration()));
            }
            case "performanceConfig": {
                return Optional.ofNullable(clazz.cast(this.performanceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("queryTransformationConfiguration", QUERY_TRANSFORMATION_CONFIGURATION_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationConfiguration, T> g) {
        return obj -> g.apply((OrchestrationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PromptTemplate promptTemplate;
        private InferenceConfig inferenceConfig;
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();
        private QueryTransformationConfiguration queryTransformationConfiguration;
        private PerformanceConfiguration performanceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationConfiguration model) {
            this.promptTemplate(model.promptTemplate);
            this.inferenceConfig(model.inferenceConfig);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.queryTransformationConfiguration(model.queryTransformationConfiguration);
            this.performanceConfig(model.performanceConfig);
        }

        public final PromptTemplate.Builder getPromptTemplate() {
            return this.promptTemplate != null ? this.promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(PromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public final InferenceConfig.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (this.additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public final QueryTransformationConfiguration.Builder getQueryTransformationConfiguration() {
            return this.queryTransformationConfiguration != null ? this.queryTransformationConfiguration.toBuilder() : null;
        }

        public final void setQueryTransformationConfiguration(QueryTransformationConfiguration.BuilderImpl queryTransformationConfiguration) {
            this.queryTransformationConfiguration = queryTransformationConfiguration != null ? queryTransformationConfiguration.build() : null;
        }

        @Override
        public final Builder queryTransformationConfiguration(QueryTransformationConfiguration queryTransformationConfiguration) {
            this.queryTransformationConfiguration = queryTransformationConfiguration;
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return this.performanceConfig != null ? this.performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        public OrchestrationConfiguration build() {
            return new OrchestrationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrchestrationConfiguration> {
        public Builder promptTemplate(PromptTemplate var1);

        default public Builder promptTemplate(Consumer<PromptTemplate.Builder> promptTemplate) {
            return this.promptTemplate((PromptTemplate)((PromptTemplate.Builder)PromptTemplate.builder().applyMutation(promptTemplate)).build());
        }

        public Builder inferenceConfig(InferenceConfig var1);

        default public Builder inferenceConfig(Consumer<InferenceConfig.Builder> inferenceConfig) {
            return this.inferenceConfig((InferenceConfig)((InferenceConfig.Builder)InferenceConfig.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder additionalModelRequestFields(Map<String, Document> var1);

        public Builder queryTransformationConfiguration(QueryTransformationConfiguration var1);

        default public Builder queryTransformationConfiguration(Consumer<QueryTransformationConfiguration.Builder> queryTransformationConfiguration) {
            return this.queryTransformationConfiguration((QueryTransformationConfiguration)((QueryTransformationConfiguration.Builder)QueryTransformationConfiguration.builder().applyMutation(queryTransformationConfiguration)).build());
        }

        public Builder performanceConfig(PerformanceConfiguration var1);

        default public Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return this.performanceConfig((PerformanceConfiguration)((PerformanceConfiguration.Builder)PerformanceConfiguration.builder().applyMutation(performanceConfig)).build());
        }
    }
}

