/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationStepPayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInvocationStepRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, PutInvocationStepRequest> {
    private static final SdkField<String> SESSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionIdentifier").getter(PutInvocationStepRequest.getter(PutInvocationStepRequest::sessionIdentifier)).setter(PutInvocationStepRequest.setter(Builder::sessionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionIdentifier").build()}).build();
    private static final SdkField<String> INVOCATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationIdentifier").getter(PutInvocationStepRequest.getter(PutInvocationStepRequest::invocationIdentifier)).setter(PutInvocationStepRequest.setter(Builder::invocationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationIdentifier").build()}).build();
    private static final SdkField<Instant> INVOCATION_STEP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("invocationStepTime").getter(PutInvocationStepRequest.getter(PutInvocationStepRequest::invocationStepTime)).setter(PutInvocationStepRequest.setter(Builder::invocationStepTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStepTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<InvocationStepPayload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("payload").getter(PutInvocationStepRequest.getter(PutInvocationStepRequest::payload)).setter(PutInvocationStepRequest.setter(Builder::payload)).constructor(InvocationStepPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<String> INVOCATION_STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationStepId").getter(PutInvocationStepRequest.getter(PutInvocationStepRequest::invocationStepId)).setter(PutInvocationStepRequest.setter(Builder::invocationStepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStepId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_IDENTIFIER_FIELD, INVOCATION_IDENTIFIER_FIELD, INVOCATION_STEP_TIME_FIELD, PAYLOAD_FIELD, INVOCATION_STEP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutInvocationStepRequest.memberNameToFieldInitializer();
    private final String sessionIdentifier;
    private final String invocationIdentifier;
    private final Instant invocationStepTime;
    private final InvocationStepPayload payload;
    private final String invocationStepId;

    private PutInvocationStepRequest(BuilderImpl builder) {
        super(builder);
        this.sessionIdentifier = builder.sessionIdentifier;
        this.invocationIdentifier = builder.invocationIdentifier;
        this.invocationStepTime = builder.invocationStepTime;
        this.payload = builder.payload;
        this.invocationStepId = builder.invocationStepId;
    }

    public final String sessionIdentifier() {
        return this.sessionIdentifier;
    }

    public final String invocationIdentifier() {
        return this.invocationIdentifier;
    }

    public final Instant invocationStepTime() {
        return this.invocationStepTime;
    }

    public final InvocationStepPayload payload() {
        return this.payload;
    }

    public final String invocationStepId() {
        return this.invocationStepId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationStepTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationStepId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInvocationStepRequest)) {
            return false;
        }
        PutInvocationStepRequest other = (PutInvocationStepRequest)((Object)obj);
        return Objects.equals(this.sessionIdentifier(), other.sessionIdentifier()) && Objects.equals(this.invocationIdentifier(), other.invocationIdentifier()) && Objects.equals(this.invocationStepTime(), other.invocationStepTime()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.invocationStepId(), other.invocationStepId());
    }

    public final String toString() {
        return ToString.builder((String)"PutInvocationStepRequest").add("SessionIdentifier", (Object)this.sessionIdentifier()).add("InvocationIdentifier", (Object)this.invocationIdentifier()).add("InvocationStepTime", (Object)this.invocationStepTime()).add("Payload", (Object)this.payload()).add("InvocationStepId", (Object)this.invocationStepId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sessionIdentifier()));
            }
            case "invocationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.invocationIdentifier()));
            }
            case "invocationStepTime": {
                return Optional.ofNullable(clazz.cast(this.invocationStepTime()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "invocationStepId": {
                return Optional.ofNullable(clazz.cast(this.invocationStepId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionIdentifier", SESSION_IDENTIFIER_FIELD);
        map.put("invocationIdentifier", INVOCATION_IDENTIFIER_FIELD);
        map.put("invocationStepTime", INVOCATION_STEP_TIME_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("invocationStepId", INVOCATION_STEP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInvocationStepRequest, T> g) {
        return obj -> g.apply((PutInvocationStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String sessionIdentifier;
        private String invocationIdentifier;
        private Instant invocationStepTime;
        private InvocationStepPayload payload;
        private String invocationStepId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInvocationStepRequest model) {
            super(model);
            this.sessionIdentifier(model.sessionIdentifier);
            this.invocationIdentifier(model.invocationIdentifier);
            this.invocationStepTime(model.invocationStepTime);
            this.payload(model.payload);
            this.invocationStepId(model.invocationStepId);
        }

        public final String getSessionIdentifier() {
            return this.sessionIdentifier;
        }

        public final void setSessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public final Builder sessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
            return this;
        }

        public final String getInvocationIdentifier() {
            return this.invocationIdentifier;
        }

        public final void setInvocationIdentifier(String invocationIdentifier) {
            this.invocationIdentifier = invocationIdentifier;
        }

        @Override
        public final Builder invocationIdentifier(String invocationIdentifier) {
            this.invocationIdentifier = invocationIdentifier;
            return this;
        }

        public final Instant getInvocationStepTime() {
            return this.invocationStepTime;
        }

        public final void setInvocationStepTime(Instant invocationStepTime) {
            this.invocationStepTime = invocationStepTime;
        }

        @Override
        public final Builder invocationStepTime(Instant invocationStepTime) {
            this.invocationStepTime = invocationStepTime;
            return this;
        }

        public final InvocationStepPayload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(InvocationStepPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(InvocationStepPayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getInvocationStepId() {
            return this.invocationStepId;
        }

        public final void setInvocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
        }

        @Override
        public final Builder invocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInvocationStepRequest build() {
            return new PutInvocationStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInvocationStepRequest> {
        public Builder sessionIdentifier(String var1);

        public Builder invocationIdentifier(String var1);

        public Builder invocationStepTime(Instant var1);

        public Builder payload(InvocationStepPayload var1);

        default public Builder payload(Consumer<InvocationStepPayload.Builder> payload) {
            return this.payload((InvocationStepPayload)((InvocationStepPayload.Builder)InvocationStepPayload.builder().applyMutation(payload)).build());
        }

        public Builder invocationStepId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

