/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionSummary;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionsResponse;

public class ListFlowExecutionsPublisher
implements SdkPublisher<ListFlowExecutionsResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final ListFlowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowExecutionsPublisher(BedrockAgentRuntimeAsyncClient client, ListFlowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowExecutionsPublisher(BedrockAgentRuntimeAsyncClient client, ListFlowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowExecutionSummary> flowExecutionSummaries() {
        Function<ListFlowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowExecutionSummaries() != null) {
                return response.flowExecutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowExecutionsResponseFetcher
    implements AsyncPageFetcher<ListFlowExecutionsResponse> {
        private ListFlowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowExecutionsResponse> nextPage(ListFlowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowExecutionsPublisher.this.client.listFlowExecutions(ListFlowExecutionsPublisher.this.firstRequest);
            }
            return ListFlowExecutionsPublisher.this.client.listFlowExecutions((ListFlowExecutionsRequest)((Object)ListFlowExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

