/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse;

public class ListInvocationsIterable
implements SdkIterable<ListInvocationsResponse> {
    private final BedrockAgentRuntimeClient client;
    private final ListInvocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvocationsIterable(BedrockAgentRuntimeClient client, ListInvocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvocationsResponseFetcher();
    }

    public Iterator<ListInvocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvocationSummary> invocationSummaries() {
        Function<ListInvocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invocationSummaries() != null) {
                return response.invocationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvocationsResponseFetcher
    implements SyncPageFetcher<ListInvocationsResponse> {
        private ListInvocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvocationsResponse nextPage(ListInvocationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvocationsIterable.this.client.listInvocations(ListInvocationsIterable.this.firstRequest);
            }
            return ListInvocationsIterable.this.client.listInvocations((ListInvocationsRequest)((Object)ListInvocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

