/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionError;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionErrorsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFlowExecutionResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, GetFlowExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::executionArn)).setter(GetFlowExecutionResponse.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::statusAsString)).setter(GetFlowExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::startedAt)).setter(GetFlowExecutionResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::endedAt)).setter(GetFlowExecutionResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<FlowExecutionError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::errors)).setter(GetFlowExecutionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowExecutionError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::flowAliasIdentifier)).setter(GetFlowExecutionResponse.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::flowIdentifier)).setter(GetFlowExecutionResponse.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowVersion").getter(GetFlowExecutionResponse.getter(GetFlowExecutionResponse::flowVersion)).setter(GetFlowExecutionResponse.setter(Builder::flowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, STATUS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, ERRORS_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD, FLOW_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFlowExecutionResponse.memberNameToFieldInitializer();
    private final String executionArn;
    private final String status;
    private final Instant startedAt;
    private final Instant endedAt;
    private final List<FlowExecutionError> errors;
    private final String flowAliasIdentifier;
    private final String flowIdentifier;
    private final String flowVersion;

    private GetFlowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.errors = builder.errors;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.flowVersion = builder.flowVersion;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<FlowExecutionError> errors() {
        return this.errors;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String flowVersion() {
        return this.flowVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowExecutionResponse)) {
            return false;
        }
        GetFlowExecutionResponse other = (GetFlowExecutionResponse)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.flowVersion(), other.flowVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetFlowExecutionResponse").add("ExecutionArn", (Object)this.executionArn()).add("Status", (Object)this.statusAsString()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("Errors", this.hasErrors() ? this.errors() : null).add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("FlowVersion", (Object)this.flowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "flowVersion": {
                return Optional.ofNullable(clazz.cast(this.flowVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowVersion", FLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFlowExecutionResponse, T> g) {
        return obj -> g.apply((GetFlowExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private String executionArn;
        private String status;
        private Instant startedAt;
        private Instant endedAt;
        private List<FlowExecutionError> errors = DefaultSdkAutoConstructList.getInstance();
        private String flowAliasIdentifier;
        private String flowIdentifier;
        private String flowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowExecutionResponse model) {
            super(model);
            this.executionArn(model.executionArn);
            this.status(model.status);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.errors(model.errors);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.flowIdentifier(model.flowIdentifier);
            this.flowVersion(model.flowVersion);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final List<FlowExecutionError.Builder> getErrors() {
            List<FlowExecutionError.Builder> result = FlowExecutionErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FlowExecutionError.BuilderImpl> errors) {
            this.errors = FlowExecutionErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FlowExecutionError> errors) {
            this.errors = FlowExecutionErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FlowExecutionError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FlowExecutionError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (FlowExecutionError)((FlowExecutionError.Builder)FlowExecutionError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowVersion() {
            return this.flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        @Override
        public GetFlowExecutionResponse build() {
            return new GetFlowExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFlowExecutionResponse> {
        public Builder executionArn(String var1);

        public Builder status(String var1);

        public Builder status(FlowExecutionStatus var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder errors(Collection<FlowExecutionError> var1);

        public Builder errors(FlowExecutionError ... var1);

        public Builder errors(Consumer<FlowExecutionError.Builder> ... var1);

        public Builder flowAliasIdentifier(String var1);

        public Builder flowIdentifier(String var1);

        public Builder flowVersion(String var1);
    }
}

