/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionSummariesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowExecutionsResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, ListFlowExecutionsResponse> {
    private static final SdkField<List<FlowExecutionSummary>> FLOW_EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flowExecutionSummaries").getter(ListFlowExecutionsResponse.getter(ListFlowExecutionsResponse::flowExecutionSummaries)).setter(ListFlowExecutionsResponse.setter(Builder::flowExecutionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFlowExecutionsResponse.getter(ListFlowExecutionsResponse::nextToken)).setter(ListFlowExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowExecutionsResponse.memberNameToFieldInitializer();
    private final List<FlowExecutionSummary> flowExecutionSummaries;
    private final String nextToken;

    private ListFlowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.flowExecutionSummaries = builder.flowExecutionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFlowExecutionSummaries() {
        return this.flowExecutionSummaries != null && !(this.flowExecutionSummaries instanceof SdkAutoConstructList);
    }

    public final List<FlowExecutionSummary> flowExecutionSummaries() {
        return this.flowExecutionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowExecutionSummaries() ? this.flowExecutionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowExecutionsResponse)) {
            return false;
        }
        ListFlowExecutionsResponse other = (ListFlowExecutionsResponse)((Object)obj);
        return this.hasFlowExecutionSummaries() == other.hasFlowExecutionSummaries() && Objects.equals(this.flowExecutionSummaries(), other.flowExecutionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowExecutionsResponse").add("FlowExecutionSummaries", this.hasFlowExecutionSummaries() ? this.flowExecutionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowExecutionSummaries": {
                return Optional.ofNullable(clazz.cast(this.flowExecutionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowExecutionSummaries", FLOW_EXECUTION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowExecutionsResponse, T> g) {
        return obj -> g.apply((ListFlowExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private List<FlowExecutionSummary> flowExecutionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowExecutionsResponse model) {
            super(model);
            this.flowExecutionSummaries(model.flowExecutionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<FlowExecutionSummary.Builder> getFlowExecutionSummaries() {
            List<FlowExecutionSummary.Builder> result = FlowExecutionSummariesCopier.copyToBuilder(this.flowExecutionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowExecutionSummaries(Collection<FlowExecutionSummary.BuilderImpl> flowExecutionSummaries) {
            this.flowExecutionSummaries = FlowExecutionSummariesCopier.copyFromBuilder(flowExecutionSummaries);
        }

        @Override
        public final Builder flowExecutionSummaries(Collection<FlowExecutionSummary> flowExecutionSummaries) {
            this.flowExecutionSummaries = FlowExecutionSummariesCopier.copy(flowExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowExecutionSummaries(FlowExecutionSummary ... flowExecutionSummaries) {
            this.flowExecutionSummaries(Arrays.asList(flowExecutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowExecutionSummaries(Consumer<FlowExecutionSummary.Builder> ... flowExecutionSummaries) {
            this.flowExecutionSummaries(Stream.of(flowExecutionSummaries).map(c -> (FlowExecutionSummary)((FlowExecutionSummary.Builder)FlowExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowExecutionsResponse build() {
            return new ListFlowExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowExecutionsResponse> {
        public Builder flowExecutionSummaries(Collection<FlowExecutionSummary> var1);

        public Builder flowExecutionSummaries(FlowExecutionSummary ... var1);

        public Builder flowExecutionSummaries(Consumer<FlowExecutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

