/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummariesCopier;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAsyncInvokesResponse
extends BedrockRuntimeResponse
implements ToCopyableBuilder<Builder, ListAsyncInvokesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAsyncInvokesResponse.getter(ListAsyncInvokesResponse::nextToken)).setter(ListAsyncInvokesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AsyncInvokeSummary>> ASYNC_INVOKE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("asyncInvokeSummaries").getter(ListAsyncInvokesResponse.getter(ListAsyncInvokesResponse::asyncInvokeSummaries)).setter(ListAsyncInvokesResponse.setter(Builder::asyncInvokeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asyncInvokeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AsyncInvokeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ASYNC_INVOKE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("asyncInvokeSummaries", ASYNC_INVOKE_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<AsyncInvokeSummary> asyncInvokeSummaries;

    private ListAsyncInvokesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.asyncInvokeSummaries = builder.asyncInvokeSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAsyncInvokeSummaries() {
        return this.asyncInvokeSummaries != null && !(this.asyncInvokeSummaries instanceof SdkAutoConstructList);
    }

    public final List<AsyncInvokeSummary> asyncInvokeSummaries() {
        return this.asyncInvokeSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsyncInvokeSummaries() ? this.asyncInvokeSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAsyncInvokesResponse)) {
            return false;
        }
        ListAsyncInvokesResponse other = (ListAsyncInvokesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAsyncInvokeSummaries() == other.hasAsyncInvokeSummaries() && Objects.equals(this.asyncInvokeSummaries(), other.asyncInvokeSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListAsyncInvokesResponse").add("NextToken", (Object)this.nextToken()).add("AsyncInvokeSummaries", this.hasAsyncInvokeSummaries() ? this.asyncInvokeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "asyncInvokeSummaries": {
                return Optional.ofNullable(clazz.cast(this.asyncInvokeSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAsyncInvokesResponse, T> g) {
        return obj -> g.apply((ListAsyncInvokesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AsyncInvokeSummary> asyncInvokeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAsyncInvokesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.asyncInvokeSummaries(model.asyncInvokeSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AsyncInvokeSummary.Builder> getAsyncInvokeSummaries() {
            List<AsyncInvokeSummary.Builder> result = AsyncInvokeSummariesCopier.copyToBuilder(this.asyncInvokeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsyncInvokeSummaries(Collection<AsyncInvokeSummary.BuilderImpl> asyncInvokeSummaries) {
            this.asyncInvokeSummaries = AsyncInvokeSummariesCopier.copyFromBuilder(asyncInvokeSummaries);
        }

        @Override
        public final Builder asyncInvokeSummaries(Collection<AsyncInvokeSummary> asyncInvokeSummaries) {
            this.asyncInvokeSummaries = AsyncInvokeSummariesCopier.copy(asyncInvokeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asyncInvokeSummaries(AsyncInvokeSummary ... asyncInvokeSummaries) {
            this.asyncInvokeSummaries(Arrays.asList(asyncInvokeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asyncInvokeSummaries(Consumer<AsyncInvokeSummary.Builder> ... asyncInvokeSummaries) {
            this.asyncInvokeSummaries(Stream.of(asyncInvokeSummaries).map(c -> (AsyncInvokeSummary)((AsyncInvokeSummary.Builder)AsyncInvokeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAsyncInvokesResponse build() {
            return new ListAsyncInvokesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAsyncInvokesResponse> {
        public Builder nextToken(String var1);

        public Builder asyncInvokeSummaries(Collection<AsyncInvokeSummary> var1);

        public Builder asyncInvokeSummaries(AsyncInvokeSummary ... var1);

        public Builder asyncInvokeSummaries(Consumer<AsyncInvokeSummary.Builder> ... var1);
    }
}

