/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockruntime.model.ApplyGuardrailRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ApplyGuardrailResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.GetAsyncInvokeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.GetAsyncInvokeResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamInput;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse;
import software.amazon.awssdk.services.bedrockruntime.model.StartAsyncInvokeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.StartAsyncInvokeResponse;
import software.amazon.awssdk.services.bedrockruntime.paginators.ListAsyncInvokesPublisher;

/**
 * Service client for accessing Amazon Bedrock Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Describes the API operations for running inference using Amazon Bedrock models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-runtime";

    /**
     * <p>
     * The action to apply a guardrail.
     * </p>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>ApplyGuardrail</code> API,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     *
     * @param applyGuardrailRequest
     * @return A Java Future containing the result of the ApplyGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ApplyGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ApplyGuardrail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyGuardrailResponse> applyGuardrail(ApplyGuardrailRequest applyGuardrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The action to apply a guardrail.
     * </p>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>ApplyGuardrail</code> API,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyGuardrailRequest.Builder} avoiding the need to
     * create one manually via {@link ApplyGuardrailRequest#builder()}
     * </p>
     *
     * @param applyGuardrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.ApplyGuardrailRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ApplyGuardrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ApplyGuardrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ApplyGuardrail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyGuardrailResponse> applyGuardrail(Consumer<ApplyGuardrailRequest.Builder> applyGuardrailRequest) {
        return applyGuardrail(ApplyGuardrailRequest.builder().applyMutation(applyGuardrailRequest).build());
    }

    /**
     * <p>
     * Sends messages to the specified Amazon Bedrock model. <code>Converse</code> provides a consistent interface that
     * works with all models that support messages. This allows you to write code once and use it with different models.
     * If a model has unique inference parameters, you can also pass those unique parameters to the model.
     * </p>
     * <p>
     * Amazon Bedrock doesn't store any text, images, or documents that you provide as content. The data is only used to
     * generate the response.
     * </p>
     * <p>
     * You can submit a prompt by including it in the <code>messages</code> field, specifying the <code>modelId</code>
     * of a foundation model or inference profile to run inference on it, and including any other fields that are
     * relevant to your use case.
     * </p>
     * <p>
     * You can also submit a prompt from Prompt management by specifying the ARN of the prompt version and including a
     * map of variables to values in the <code>promptVariables</code> field. You can append more messages to the prompt
     * by using the <code>messages</code> field. If you use a prompt from Prompt management, you can't include the
     * following fields in the request: <code>additionalModelRequestFields</code>, <code>inferenceConfig</code>,
     * <code>system</code>, or <code>toolConfig</code>. Instead, these fields must be defined through Prompt management.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-use.html">Use a prompt from Prompt
     * management</a>.
     * </p>
     * <p>
     * For information about the Converse API, see <i>Use the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * To use a guardrail, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To
     * use a tool with a model, see <i>Tool use (Function calling)</i> in the <i>Amazon Bedrock User Guide</i>
     * </p>
     * <p>
     * For example code, see <i>Converse API examples</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModel</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the base inference actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html">InvokeModel</a> and
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html">
     * InvokeModelWithResponseStream</a>). For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>Converse</code> API, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     *
     * @param converseRequest
     * @return A Java Future containing the result of the Converse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.Converse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/Converse" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConverseResponse> converse(ConverseRequest converseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends messages to the specified Amazon Bedrock model. <code>Converse</code> provides a consistent interface that
     * works with all models that support messages. This allows you to write code once and use it with different models.
     * If a model has unique inference parameters, you can also pass those unique parameters to the model.
     * </p>
     * <p>
     * Amazon Bedrock doesn't store any text, images, or documents that you provide as content. The data is only used to
     * generate the response.
     * </p>
     * <p>
     * You can submit a prompt by including it in the <code>messages</code> field, specifying the <code>modelId</code>
     * of a foundation model or inference profile to run inference on it, and including any other fields that are
     * relevant to your use case.
     * </p>
     * <p>
     * You can also submit a prompt from Prompt management by specifying the ARN of the prompt version and including a
     * map of variables to values in the <code>promptVariables</code> field. You can append more messages to the prompt
     * by using the <code>messages</code> field. If you use a prompt from Prompt management, you can't include the
     * following fields in the request: <code>additionalModelRequestFields</code>, <code>inferenceConfig</code>,
     * <code>system</code>, or <code>toolConfig</code>. Instead, these fields must be defined through Prompt management.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-use.html">Use a prompt from Prompt
     * management</a>.
     * </p>
     * <p>
     * For information about the Converse API, see <i>Use the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * To use a guardrail, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To
     * use a tool with a model, see <i>Tool use (Function calling)</i> in the <i>Amazon Bedrock User Guide</i>
     * </p>
     * <p>
     * For example code, see <i>Converse API examples</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModel</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the base inference actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html">InvokeModel</a> and
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html">
     * InvokeModelWithResponseStream</a>). For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>Converse</code> API, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConverseRequest.Builder} avoiding the need to
     * create one manually via {@link ConverseRequest#builder()}
     * </p>
     *
     * @param converseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Converse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.Converse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/Converse" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConverseResponse> converse(Consumer<ConverseRequest.Builder> converseRequest) {
        return converse(ConverseRequest.builder().applyMutation(converseRequest).build());
    }

    /**
     * <p>
     * Sends messages to the specified Amazon Bedrock model and returns the response in a stream.
     * <code>ConverseStream</code> provides a consistent API that works with all Amazon Bedrock models that support
     * messages. This allows you to write code once and use it with different models. Should a model have unique
     * inference parameters, you can also pass those unique parameters to the model.
     * </p>
     * <p>
     * To find out if a model supports streaming, call <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a>
     * and check the <code>responseStreamingSupported</code> field in the response.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including <code>ConverseStream</code>.
     * </p>
     * </note>
     * <p>
     * Amazon Bedrock doesn't store any text, images, or documents that you provide as content. The data is only used to
     * generate the response.
     * </p>
     * <p>
     * You can submit a prompt by including it in the <code>messages</code> field, specifying the <code>modelId</code>
     * of a foundation model or inference profile to run inference on it, and including any other fields that are
     * relevant to your use case.
     * </p>
     * <p>
     * You can also submit a prompt from Prompt management by specifying the ARN of the prompt version and including a
     * map of variables to values in the <code>promptVariables</code> field. You can append more messages to the prompt
     * by using the <code>messages</code> field. If you use a prompt from Prompt management, you can't include the
     * following fields in the request: <code>additionalModelRequestFields</code>, <code>inferenceConfig</code>,
     * <code>system</code>, or <code>toolConfig</code>. Instead, these fields must be defined through Prompt management.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-use.html">Use a prompt from Prompt
     * management</a>.
     * </p>
     * <p>
     * For information about the Converse API, see <i>Use the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * To use a guardrail, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To
     * use a tool with a model, see <i>Tool use (Function calling)</i> in the <i>Amazon Bedrock User Guide</i>
     * </p>
     * <p>
     * For example code, see <i>Conversation streaming example</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModelWithResponseStream</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the base inference actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html">InvokeModel</a> and
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html">
     * InvokeModelWithResponseStream</a>). For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>ConverseStream</code> API,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     *
     * @param converseStreamRequest
     * @return A Java Future containing the result of the ConverseStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ConverseStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ConverseStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> converseStream(ConverseStreamRequest converseStreamRequest,
            ConverseStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends messages to the specified Amazon Bedrock model and returns the response in a stream.
     * <code>ConverseStream</code> provides a consistent API that works with all Amazon Bedrock models that support
     * messages. This allows you to write code once and use it with different models. Should a model have unique
     * inference parameters, you can also pass those unique parameters to the model.
     * </p>
     * <p>
     * To find out if a model supports streaming, call <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a>
     * and check the <code>responseStreamingSupported</code> field in the response.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including <code>ConverseStream</code>.
     * </p>
     * </note>
     * <p>
     * Amazon Bedrock doesn't store any text, images, or documents that you provide as content. The data is only used to
     * generate the response.
     * </p>
     * <p>
     * You can submit a prompt by including it in the <code>messages</code> field, specifying the <code>modelId</code>
     * of a foundation model or inference profile to run inference on it, and including any other fields that are
     * relevant to your use case.
     * </p>
     * <p>
     * You can also submit a prompt from Prompt management by specifying the ARN of the prompt version and including a
     * map of variables to values in the <code>promptVariables</code> field. You can append more messages to the prompt
     * by using the <code>messages</code> field. If you use a prompt from Prompt management, you can't include the
     * following fields in the request: <code>additionalModelRequestFields</code>, <code>inferenceConfig</code>,
     * <code>system</code>, or <code>toolConfig</code>. Instead, these fields must be defined through Prompt management.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-use.html">Use a prompt from Prompt
     * management</a>.
     * </p>
     * <p>
     * For information about the Converse API, see <i>Use the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * To use a guardrail, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>. To
     * use a tool with a model, see <i>Tool use (Function calling)</i> in the <i>Amazon Bedrock User Guide</i>
     * </p>
     * <p>
     * For example code, see <i>Conversation streaming example</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModelWithResponseStream</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the base inference actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html">InvokeModel</a> and
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html">
     * InvokeModelWithResponseStream</a>). For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>ConverseStream</code> API,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConverseStreamRequest.Builder} avoiding the need to
     * create one manually via {@link ConverseStreamRequest#builder()}
     * </p>
     *
     * @param converseStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ConverseStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ConverseStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ConverseStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> converseStream(Consumer<ConverseStreamRequest.Builder> converseStreamRequest,
            ConverseStreamResponseHandler asyncResponseHandler) {
        return converseStream(ConverseStreamRequest.builder().applyMutation(converseStreamRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Retrieve information about an asynchronous invocation.
     * </p>
     *
     * @param getAsyncInvokeRequest
     * @return A Java Future containing the result of the GetAsyncInvoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.GetAsyncInvoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GetAsyncInvoke"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAsyncInvokeResponse> getAsyncInvoke(GetAsyncInvokeRequest getAsyncInvokeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about an asynchronous invocation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAsyncInvokeRequest.Builder} avoiding the need to
     * create one manually via {@link GetAsyncInvokeRequest#builder()}
     * </p>
     *
     * @param getAsyncInvokeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.GetAsyncInvokeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAsyncInvoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.GetAsyncInvoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GetAsyncInvoke"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAsyncInvokeResponse> getAsyncInvoke(Consumer<GetAsyncInvokeRequest.Builder> getAsyncInvokeRequest) {
        return getAsyncInvoke(GetAsyncInvokeRequest.builder().applyMutation(getAsyncInvokeRequest).build());
    }

    /**
     * <p>
     * Invokes the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in
     * the request body. You use model inference to generate text, images, and embeddings.
     * </p>
     * <p>
     * For example code, see <i>Invoke model code examples</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModel</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the Converse API actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a
     * href=
     * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>).
     * For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>InvokeModel</code> API,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     *
     * @param invokeModelRequest
     * @return A Java Future containing the result of the InvokeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.InvokeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InvokeModelResponse> invokeModel(InvokeModelRequest invokeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in
     * the request body. You use model inference to generate text, images, and embeddings.
     * </p>
     * <p>
     * For example code, see <i>Invoke model code examples</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModel</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the Converse API actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a
     * href=
     * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>).
     * For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the <code>InvokeModel</code> API,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">
     * Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeModelRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeModelRequest#builder()}
     * </p>
     *
     * @param invokeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.InvokeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InvokeModelResponse> invokeModel(Consumer<InvokeModelRequest.Builder> invokeModelRequest) {
        return invokeModel(InvokeModelRequest.builder().applyMutation(invokeModelRequest).build());
    }

    /**
     * <p>
     * Invoke the specified Amazon Bedrock model to run inference using the bidirectional stream. The response is
     * returned in a stream that remains open for 8 minutes. A single session can contain multiple prompts and responses
     * from the model. The prompts to the model are provided as audio files and the model's responses are spoken back to
     * the user and transcribed.
     * </p>
     * <p>
     * It is possible for users to interrupt the model's response with a new prompt, which will halt the response
     * speech. The model will retain contextual awareness of the conversation while pivoting to respond to the new
     * prompt.
     * </p>
     *
     * @param invokeModelWithBidirectionalStreamRequest
     * @return A Java Future containing the result of the InvokeModelWithBidirectionalStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelStreamErrorException An error occurred while streaming the response. Retry your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.InvokeModelWithBidirectionalStream
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModelWithBidirectionalStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeModelWithBidirectionalStream(
            InvokeModelWithBidirectionalStreamRequest invokeModelWithBidirectionalStreamRequest,
            Publisher<InvokeModelWithBidirectionalStreamInput> requestStream,
            InvokeModelWithBidirectionalStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invoke the specified Amazon Bedrock model to run inference using the bidirectional stream. The response is
     * returned in a stream that remains open for 8 minutes. A single session can contain multiple prompts and responses
     * from the model. The prompts to the model are provided as audio files and the model's responses are spoken back to
     * the user and transcribed.
     * </p>
     * <p>
     * It is possible for users to interrupt the model's response with a new prompt, which will halt the response
     * speech. The model will retain contextual awareness of the conversation while pivoting to respond to the new
     * prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeModelWithBidirectionalStreamRequest.Builder}
     * avoiding the need to create one manually via {@link InvokeModelWithBidirectionalStreamRequest#builder()}
     * </p>
     *
     * @param invokeModelWithBidirectionalStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the InvokeModelWithBidirectionalStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelStreamErrorException An error occurred while streaming the response. Retry your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.InvokeModelWithBidirectionalStream
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModelWithBidirectionalStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeModelWithBidirectionalStream(
            Consumer<InvokeModelWithBidirectionalStreamRequest.Builder> invokeModelWithBidirectionalStreamRequest,
            Publisher<InvokeModelWithBidirectionalStreamInput> requestStream,
            InvokeModelWithBidirectionalStreamResponseHandler asyncResponseHandler) {
        return invokeModelWithBidirectionalStream(
                InvokeModelWithBidirectionalStreamRequest.builder().applyMutation(invokeModelWithBidirectionalStreamRequest)
                        .build(), requestStream, asyncResponseHandler);
    }

    /**
     * <p>
     * Invoke the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in
     * the request body. The response is returned in a stream.
     * </p>
     * <p>
     * To see if a model supports streaming, call <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a>
     * and check the <code>responseStreamingSupported</code> field in the response.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including
     * <code>InvokeModelWithResponseStream</code>.
     * </p>
     * </note>
     * <p>
     * For example code, see <i>Invoke model with streaming code example</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the Converse API actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a
     * href=
     * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>).
     * For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the
     * <code>InvokeModelWithResponseStream</code> API, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">Troubleshooting
     * Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     *
     * @param invokeModelWithResponseStreamRequest
     * @return A Java Future containing the result of the InvokeModelWithResponseStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelStreamErrorException An error occurred while streaming the response. Retry your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.InvokeModelWithResponseStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModelWithResponseStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeModelWithResponseStream(
            InvokeModelWithResponseStreamRequest invokeModelWithResponseStreamRequest,
            InvokeModelWithResponseStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invoke the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in
     * the request body. The response is returned in a stream.
     * </p>
     * <p>
     * To see if a model supports streaming, call <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a>
     * and check the <code>responseStreamingSupported</code> field in the response.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including
     * <code>InvokeModelWithResponseStream</code>.
     * </p>
     * </note>
     * <p>
     * For example code, see <i>Invoke model with streaming code example</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the Converse API actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a
     * href=
     * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>).
     * For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     * <p>
     * For troubleshooting some of the common errors you might encounter when using the
     * <code>InvokeModelWithResponseStream</code> API, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">Troubleshooting
     * Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeModelWithResponseStreamRequest.Builder}
     * avoiding the need to create one manually via {@link InvokeModelWithResponseStreamRequest#builder()}
     * </p>
     *
     * @param invokeModelWithResponseStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the InvokeModelWithResponseStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelTimeoutException The request took too long to process. Processing time exceeded the model
     *         timeout length.</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ModelStreamErrorException An error occurred while streaming the response. Retry your request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ModelErrorException The request failed due to an error while processing the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.InvokeModelWithResponseStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModelWithResponseStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeModelWithResponseStream(
            Consumer<InvokeModelWithResponseStreamRequest.Builder> invokeModelWithResponseStreamRequest,
            InvokeModelWithResponseStreamResponseHandler asyncResponseHandler) {
        return invokeModelWithResponseStream(
                InvokeModelWithResponseStreamRequest.builder().applyMutation(invokeModelWithResponseStreamRequest).build(),
                asyncResponseHandler);
    }

    /**
     * <p>
     * Lists asynchronous invocations.
     * </p>
     *
     * @param listAsyncInvokesRequest
     * @return A Java Future containing the result of the ListAsyncInvokes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ListAsyncInvokes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ListAsyncInvokes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAsyncInvokesResponse> listAsyncInvokes(ListAsyncInvokesRequest listAsyncInvokesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists asynchronous invocations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAsyncInvokesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAsyncInvokesRequest#builder()}
     * </p>
     *
     * @param listAsyncInvokesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAsyncInvokes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ListAsyncInvokes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ListAsyncInvokes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAsyncInvokesResponse> listAsyncInvokes(
            Consumer<ListAsyncInvokesRequest.Builder> listAsyncInvokesRequest) {
        return listAsyncInvokes(ListAsyncInvokesRequest.builder().applyMutation(listAsyncInvokesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAsyncInvokes(software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockruntime.paginators.ListAsyncInvokesPublisher publisher = client.listAsyncInvokesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockruntime.paginators.ListAsyncInvokesPublisher publisher = client.listAsyncInvokesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAsyncInvokes(software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAsyncInvokesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ListAsyncInvokes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ListAsyncInvokes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAsyncInvokesPublisher listAsyncInvokesPaginator(ListAsyncInvokesRequest listAsyncInvokesRequest) {
        return new ListAsyncInvokesPublisher(this, listAsyncInvokesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAsyncInvokes(software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockruntime.paginators.ListAsyncInvokesPublisher publisher = client.listAsyncInvokesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockruntime.paginators.ListAsyncInvokesPublisher publisher = client.listAsyncInvokesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAsyncInvokes(software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAsyncInvokesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAsyncInvokesRequest#builder()}
     * </p>
     *
     * @param listAsyncInvokesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.ListAsyncInvokes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ListAsyncInvokes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAsyncInvokesPublisher listAsyncInvokesPaginator(Consumer<ListAsyncInvokesRequest.Builder> listAsyncInvokesRequest) {
        return listAsyncInvokesPaginator(ListAsyncInvokesRequest.builder().applyMutation(listAsyncInvokesRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous invocation.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModel</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the Converse API actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a
     * href=
     * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>).
     * For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important>
     *
     * @param startAsyncInvokeRequest
     * @return A Java Future containing the result of the StartAsyncInvoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.StartAsyncInvoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/StartAsyncInvoke"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAsyncInvokeResponse> startAsyncInvoke(StartAsyncInvokeRequest startAsyncInvokeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous invocation.
     * </p>
     * <p>
     * This operation requires permission for the <code>bedrock:InvokeModel</code> action.
     * </p>
     * <important>
     * <p>
     * To deny all inference access to resources that you specify in the modelId field, you need to deny access to the
     * <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also
     * denies access to the resource through the Converse API actions (<a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a
     * href=
     * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>).
     * For more information see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference"
     * >Deny access for inference on specific models</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAsyncInvokeRequest.Builder} avoiding the need
     * to create one manually via {@link StartAsyncInvokeRequest#builder()}
     * </p>
     *
     * @param startAsyncInvokeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockruntime.model.StartAsyncInvokeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartAsyncInvoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The request is denied because you do not have sufficient permissions to perform
     *         the requested action. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied"
     *         >AccessDeniedException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ThrottlingException Your request was denied due to exceeding the account quotas for <i>Amazon
     *         Bedrock</i>. For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception"
     *         >ThrottlingException</a> in the Amazon Bedrock User Guide</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found"
     *         >ResourceNotFound</a> in the Amazon Bedrock User Guide</li>
     *         <li>InternalServerException An internal server error occurred. For troubleshooting this error, see <a
     *         href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure"
     *         >InternalFailure</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceUnavailableException The service isn't currently available. For troubleshooting this error,
     *         see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable"
     *         >ServiceUnavailable</a> in the Amazon Bedrock User Guide</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>.
     *         For troubleshooting this error, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error"
     *         >ValidationError</a> in the Amazon Bedrock User Guide</li>
     *         <li>ServiceQuotaExceededException Your request exceeds the service quota for your account. You can view
     *         your quotas at <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service
     *         quotas</a>. You can resubmit your request later.</li>
     *         <li>ConflictException Error occurred because of a conflict while performing an operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BedrockRuntimeAsyncClient.StartAsyncInvoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/StartAsyncInvoke"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAsyncInvokeResponse> startAsyncInvoke(
            Consumer<StartAsyncInvokeRequest.Builder> startAsyncInvokeRequest) {
        return startAsyncInvoke(StartAsyncInvokeRequest.builder().applyMutation(startAsyncInvokeRequest).build());
    }

    @Override
    default BedrockRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockRuntimeAsyncClient}.
     */
    static BedrockRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockRuntimeAsyncClientBuilder();
    }
}
