/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultContentBlockStart;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultContentBlockStop;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultMessageStart;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultMessageStop;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultMetadata;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Base interface for all event types in ConverseStreamOutput.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface ConverseStreamOutput extends SdkPojo {
    /**
     * Special type of {@link ConverseStreamOutput} for unknown types of events that this version of the SDK does not
     * know about
     */
    ConverseStreamOutput UNKNOWN = new ConverseStreamOutput() {
        @Override
        public List<SdkField<?>> sdkFields() {
            return Collections.emptyList();
        }

        @Override
        public void accept(ConverseStreamResponseHandler.Visitor visitor) {
            visitor.visitDefault(this);
        }
    };

    /**
     * Create a builder for the {@code messageStart} event type for this stream.
     */
    static MessageStartEvent.Builder messageStartBuilder() {
        return DefaultMessageStart.builder();
    }

    /**
     * Create a builder for the {@code contentBlockStart} event type for this stream.
     */
    static ContentBlockStartEvent.Builder contentBlockStartBuilder() {
        return DefaultContentBlockStart.builder();
    }

    /**
     * Create a builder for the {@code contentBlockDelta} event type for this stream.
     */
    static ContentBlockDeltaEvent.Builder contentBlockDeltaBuilder() {
        return DefaultContentBlockDelta.builder();
    }

    /**
     * Create a builder for the {@code contentBlockStop} event type for this stream.
     */
    static ContentBlockStopEvent.Builder contentBlockStopBuilder() {
        return DefaultContentBlockStop.builder();
    }

    /**
     * Create a builder for the {@code messageStop} event type for this stream.
     */
    static MessageStopEvent.Builder messageStopBuilder() {
        return DefaultMessageStop.builder();
    }

    /**
     * Create a builder for the {@code metadata} event type for this stream.
     */
    static ConverseStreamMetadataEvent.Builder metadataBuilder() {
        return DefaultMetadata.builder();
    }

    /**
     * The type of this event. Corresponds to the {@code :event-type} header on the Message.
     */
    default EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link ConverseStreamOutput}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    void accept(ConverseStreamResponseHandler.Visitor visitor);

    /**
     * The known possible types of events for {@code ConverseStreamOutput}.
     */
    @Generated("software.amazon.awssdk:codegen")
    enum EventType {
        MESSAGE_START("messageStart"),

        CONTENT_BLOCK_START("contentBlockStart"),

        CONTENT_BLOCK_DELTA("contentBlockDelta"),

        CONTENT_BLOCK_STOP("contentBlockStop"),

        MESSAGE_STOP("messageStop"),

        METADATA("metadata"),

        UNKNOWN_TO_SDK_VERSION(null);

        private static final Map<String, EventType> VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);

        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        /**
         * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
         *
         * @param value
         *        real value
         * @return EventType corresponding to the value
         */
        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
        }

        /**
         * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will
         * return all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
         *
         * @return a {@link Set} of known {@link EventType}s
         */
        public static Set<EventType> knownValues() {
            Set<EventType> knownValues = EnumSet.allOf(EventType.class);
            knownValues.remove(UNKNOWN_TO_SDK_VERSION);
            return knownValues;
        }
    }
}
