/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of an attribute key and an attribute value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeKeyAndValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeKeyAndValue.Builder, AttributeKeyAndValue> {
    private static final SdkField<AttributeKey> KEY_FIELD = SdkField.<AttributeKey> builder(MarshallingType.SDK_POJO)
            .memberName("Key").getter(getter(AttributeKeyAndValue::key)).setter(setter(Builder::key))
            .constructor(AttributeKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<TypedAttributeValue> VALUE_FIELD = SdkField
            .<TypedAttributeValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(AttributeKeyAndValue::value)).setter(setter(Builder::value)).constructor(TypedAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AttributeKey key;

    private final TypedAttributeValue value;

    private AttributeKeyAndValue(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The key of the attribute.
     * </p>
     * 
     * @return The key of the attribute.
     */
    public final AttributeKey key() {
        return key;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public final TypedAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeKeyAndValue)) {
            return false;
        }
        AttributeKeyAndValue other = (AttributeKeyAndValue) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeKeyAndValue").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeKeyAndValue, T> g) {
        return obj -> g.apply((AttributeKeyAndValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeKeyAndValue> {
        /**
         * <p>
         * The key of the attribute.
         * </p>
         * 
         * @param key
         *        The key of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(AttributeKey key);

        /**
         * <p>
         * The key of the attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeKey.Builder} avoiding the need
         * to create one manually via {@link AttributeKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeKey.Builder#build()} is called immediately and its
         * result is passed to {@link #key(AttributeKey)}.
         * 
         * @param key
         *        a consumer that will call methods on {@link AttributeKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #key(AttributeKey)
         */
        default Builder key(Consumer<AttributeKey.Builder> key) {
            return key(AttributeKey.builder().applyMutation(key).build());
        }

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(TypedAttributeValue value);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedAttributeValue.Builder} avoiding the
         * need to create one manually via {@link TypedAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(TypedAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link TypedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(TypedAttributeValue)
         */
        default Builder value(Consumer<TypedAttributeValue.Builder> value) {
            return value(TypedAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttributeKey key;

        private TypedAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeKeyAndValue model) {
            key(model.key);
            value(model.value);
        }

        public final AttributeKey.Builder getKey() {
            return key != null ? key.toBuilder() : null;
        }

        public final void setKey(AttributeKey.BuilderImpl key) {
            this.key = key != null ? key.build() : null;
        }

        @Override
        public final Builder key(AttributeKey key) {
            this.key = key;
            return this;
        }

        public final TypedAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(TypedAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(TypedAttributeValue value) {
            this.value = value;
            return this;
        }

        @Override
        public AttributeKeyAndValue build() {
            return new AttributeKeyAndValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
