/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLinkAttributesRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<UpdateLinkAttributesRequest.Builder, UpdateLinkAttributesRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(UpdateLinkAttributesRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<TypedLinkSpecifier> TYPED_LINK_SPECIFIER_FIELD = SdkField
            .<TypedLinkSpecifier> builder(MarshallingType.SDK_POJO).memberName("TypedLinkSpecifier")
            .getter(getter(UpdateLinkAttributesRequest::typedLinkSpecifier)).setter(setter(Builder::typedLinkSpecifier))
            .constructor(TypedLinkSpecifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifier").build())
            .build();

    private static final SdkField<List<LinkAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField
            .<List<LinkAttributeUpdate>> builder(MarshallingType.LIST)
            .memberName("AttributeUpdates")
            .getter(getter(UpdateLinkAttributesRequest::attributeUpdates))
            .setter(setter(Builder::attributeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LinkAttributeUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(LinkAttributeUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            TYPED_LINK_SPECIFIER_FIELD, ATTRIBUTE_UPDATES_FIELD));

    private final String directoryArn;

    private final TypedLinkSpecifier typedLinkSpecifier;

    private final List<LinkAttributeUpdate> attributeUpdates;

    private UpdateLinkAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeUpdates = builder.attributeUpdates;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For
     * more information, see <a>arns</a> or <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link
     *         resides. For more information, see <a>arns</a> or <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Allows a typed link specifier to be accepted as input.
     * </p>
     * 
     * @return Allows a typed link specifier to be accepted as input.
     */
    public final TypedLinkSpecifier typedLinkSpecifier() {
        return typedLinkSpecifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeUpdates() {
        return attributeUpdates != null && !(attributeUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes update structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeUpdates} method.
     * </p>
     * 
     * @return The attributes update structure.
     */
    public final List<LinkAttributeUpdate> attributeUpdates() {
        return attributeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeUpdates() ? attributeUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkAttributesRequest)) {
            return false;
        }
        UpdateLinkAttributesRequest other = (UpdateLinkAttributesRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn())
                && Objects.equals(typedLinkSpecifier(), other.typedLinkSpecifier())
                && hasAttributeUpdates() == other.hasAttributeUpdates()
                && Objects.equals(attributeUpdates(), other.attributeUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLinkAttributesRequest").add("DirectoryArn", directoryArn())
                .add("TypedLinkSpecifier", typedLinkSpecifier())
                .add("AttributeUpdates", hasAttributeUpdates() ? attributeUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "TypedLinkSpecifier":
            return Optional.ofNullable(clazz.cast(typedLinkSpecifier()));
        case "AttributeUpdates":
            return Optional.ofNullable(clazz.cast(attributeUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkAttributesRequest, T> g) {
        return obj -> g.apply((UpdateLinkAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLinkAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides.
         * For more information, see <a>arns</a> or <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link
         *        resides. For more information, see <a>arns</a> or <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Allows a typed link specifier to be accepted as input.
         * </p>
         * 
         * @param typedLinkSpecifier
         *        Allows a typed link specifier to be accepted as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier);

        /**
         * <p>
         * Allows a typed link specifier to be accepted as input.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedLinkSpecifier.Builder} avoiding the
         * need to create one manually via {@link TypedLinkSpecifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSpecifier.Builder#build()} is called immediately and its
         * result is passed to {@link #typedLinkSpecifier(TypedLinkSpecifier)}.
         * 
         * @param typedLinkSpecifier
         *        a consumer that will call methods on {@link TypedLinkSpecifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typedLinkSpecifier(TypedLinkSpecifier)
         */
        default Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return typedLinkSpecifier(TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier).build());
        }

        /**
         * <p>
         * The attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        The attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(Collection<LinkAttributeUpdate> attributeUpdates);

        /**
         * <p>
         * The attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        The attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(LinkAttributeUpdate... attributeUpdates);

        /**
         * <p>
         * The attributes update structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LinkAttributeUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<LinkAttributeUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LinkAttributeUpdate>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeUpdates(List<LinkAttributeUpdate>)}.
         * 
         * @param attributeUpdates
         *        a consumer that will call methods on {@link List<LinkAttributeUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeUpdates(List<LinkAttributeUpdate>)
         */
        Builder attributeUpdates(Consumer<LinkAttributeUpdate.Builder>... attributeUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private TypedLinkSpecifier typedLinkSpecifier;

        private List<LinkAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkAttributesRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            typedLinkSpecifier(model.typedLinkSpecifier);
            attributeUpdates(model.attributeUpdates);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return typedLinkSpecifier != null ? typedLinkSpecifier.toBuilder() : null;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final List<LinkAttributeUpdate.Builder> getAttributeUpdates() {
            List<LinkAttributeUpdate.Builder> result = LinkAttributeUpdateListCopier.copyToBuilder(this.attributeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeUpdates(Collection<LinkAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = LinkAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public final Builder attributeUpdates(Collection<LinkAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = LinkAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(LinkAttributeUpdate... attributeUpdates) {
            attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<LinkAttributeUpdate.Builder>... attributeUpdates) {
            attributeUpdates(Stream.of(attributeUpdates).map(c -> LinkAttributeUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkAttributesRequest build() {
            return new UpdateLinkAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
