/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CachePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CachePolicy> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CachePolicy.getter(CachePolicy::id)).setter(CachePolicy.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(CachePolicy.getter(CachePolicy::lastModifiedTime)).setter(CachePolicy.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CachePolicyConfig").getter(CachePolicy.getter(CachePolicy::cachePolicyConfig)).setter(CachePolicy.setter(Builder::cachePolicyConfig)).constructor(CachePolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig").unmarshallLocationName("CachePolicyConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LAST_MODIFIED_TIME_FIELD, CACHE_POLICY_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant lastModifiedTime;
    private final CachePolicyConfig cachePolicyConfig;

    private CachePolicy(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.cachePolicyConfig = builder.cachePolicyConfig;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final CachePolicyConfig cachePolicyConfig() {
        return this.cachePolicyConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicy)) {
            return false;
        }
        CachePolicy other = (CachePolicy)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.cachePolicyConfig(), other.cachePolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CachePolicy").add("Id", (Object)this.id()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CachePolicyConfig", (Object)this.cachePolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CachePolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.cachePolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachePolicy, T> g) {
        return obj -> g.apply((CachePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant lastModifiedTime;
        private CachePolicyConfig cachePolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicy model) {
            this.id(model.id);
            this.lastModifiedTime(model.lastModifiedTime);
            this.cachePolicyConfig(model.cachePolicyConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return this.cachePolicyConfig != null ? this.cachePolicyConfig.toBuilder() : null;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        @Override
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        public CachePolicy build() {
            return new CachePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CachePolicy> {
        public Builder id(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder cachePolicyConfig(CachePolicyConfig var1);

        default public Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return this.cachePolicyConfig((CachePolicyConfig)((CachePolicyConfig.Builder)CachePolicyConfig.builder().applyMutation(cachePolicyConfig)).build());
        }
    }
}

