/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CachePolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CachePolicyConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CachePolicyConfig.getter(CachePolicyConfig::comment)).setter(CachePolicyConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CachePolicyConfig.getter(CachePolicyConfig::name)).setter(CachePolicyConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<Long> DEFAULT_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DefaultTTL").getter(CachePolicyConfig.getter(CachePolicyConfig::defaultTTL)).setter(CachePolicyConfig.setter(Builder::defaultTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTTL").unmarshallLocationName("DefaultTTL").build()}).build();
    private static final SdkField<Long> MAX_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxTTL").getter(CachePolicyConfig.getter(CachePolicyConfig::maxTTL)).setter(CachePolicyConfig.setter(Builder::maxTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTTL").unmarshallLocationName("MaxTTL").build()}).build();
    private static final SdkField<Long> MIN_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinTTL").getter(CachePolicyConfig.getter(CachePolicyConfig::minTTL)).setter(CachePolicyConfig.setter(Builder::minTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTTL").unmarshallLocationName("MinTTL").build()}).build();
    private static final SdkField<ParametersInCacheKeyAndForwardedToOrigin> PARAMETERS_IN_CACHE_KEY_AND_FORWARDED_TO_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParametersInCacheKeyAndForwardedToOrigin").getter(CachePolicyConfig.getter(CachePolicyConfig::parametersInCacheKeyAndForwardedToOrigin)).setter(CachePolicyConfig.setter(Builder::parametersInCacheKeyAndForwardedToOrigin)).constructor(ParametersInCacheKeyAndForwardedToOrigin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersInCacheKeyAndForwardedToOrigin").unmarshallLocationName("ParametersInCacheKeyAndForwardedToOrigin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, NAME_FIELD, DEFAULT_TTL_FIELD, MAX_TTL_FIELD, MIN_TTL_FIELD, PARAMETERS_IN_CACHE_KEY_AND_FORWARDED_TO_ORIGIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final String name;
    private final Long defaultTTL;
    private final Long maxTTL;
    private final Long minTTL;
    private final ParametersInCacheKeyAndForwardedToOrigin parametersInCacheKeyAndForwardedToOrigin;

    private CachePolicyConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.name = builder.name;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
        this.minTTL = builder.minTTL;
        this.parametersInCacheKeyAndForwardedToOrigin = builder.parametersInCacheKeyAndForwardedToOrigin;
    }

    public final String comment() {
        return this.comment;
    }

    public final String name() {
        return this.name;
    }

    public final Long defaultTTL() {
        return this.defaultTTL;
    }

    public final Long maxTTL() {
        return this.maxTTL;
    }

    public final Long minTTL() {
        return this.minTTL;
    }

    public final ParametersInCacheKeyAndForwardedToOrigin parametersInCacheKeyAndForwardedToOrigin() {
        return this.parametersInCacheKeyAndForwardedToOrigin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersInCacheKeyAndForwardedToOrigin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicyConfig)) {
            return false;
        }
        CachePolicyConfig other = (CachePolicyConfig)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultTTL(), other.defaultTTL()) && Objects.equals(this.maxTTL(), other.maxTTL()) && Objects.equals(this.minTTL(), other.minTTL()) && Objects.equals(this.parametersInCacheKeyAndForwardedToOrigin(), other.parametersInCacheKeyAndForwardedToOrigin());
    }

    public final String toString() {
        return ToString.builder((String)"CachePolicyConfig").add("Comment", (Object)this.comment()).add("Name", (Object)this.name()).add("DefaultTTL", (Object)this.defaultTTL()).add("MaxTTL", (Object)this.maxTTL()).add("MinTTL", (Object)this.minTTL()).add("ParametersInCacheKeyAndForwardedToOrigin", (Object)this.parametersInCacheKeyAndForwardedToOrigin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefaultTTL": {
                return Optional.ofNullable(clazz.cast(this.defaultTTL()));
            }
            case "MaxTTL": {
                return Optional.ofNullable(clazz.cast(this.maxTTL()));
            }
            case "MinTTL": {
                return Optional.ofNullable(clazz.cast(this.minTTL()));
            }
            case "ParametersInCacheKeyAndForwardedToOrigin": {
                return Optional.ofNullable(clazz.cast(this.parametersInCacheKeyAndForwardedToOrigin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachePolicyConfig, T> g) {
        return obj -> g.apply((CachePolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String name;
        private Long defaultTTL;
        private Long maxTTL;
        private Long minTTL;
        private ParametersInCacheKeyAndForwardedToOrigin parametersInCacheKeyAndForwardedToOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicyConfig model) {
            this.comment(model.comment);
            this.name(model.name);
            this.defaultTTL(model.defaultTTL);
            this.maxTTL(model.maxTTL);
            this.minTTL(model.minTTL);
            this.parametersInCacheKeyAndForwardedToOrigin(model.parametersInCacheKeyAndForwardedToOrigin);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getDefaultTTL() {
            return this.defaultTTL;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final Long getMaxTTL() {
            return this.maxTTL;
        }

        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        @Override
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        public final Long getMinTTL() {
            return this.minTTL;
        }

        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        @Override
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        public final ParametersInCacheKeyAndForwardedToOrigin.Builder getParametersInCacheKeyAndForwardedToOrigin() {
            return this.parametersInCacheKeyAndForwardedToOrigin != null ? this.parametersInCacheKeyAndForwardedToOrigin.toBuilder() : null;
        }

        public final void setParametersInCacheKeyAndForwardedToOrigin(ParametersInCacheKeyAndForwardedToOrigin.BuilderImpl parametersInCacheKeyAndForwardedToOrigin) {
            this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin != null ? parametersInCacheKeyAndForwardedToOrigin.build() : null;
        }

        @Override
        public final Builder parametersInCacheKeyAndForwardedToOrigin(ParametersInCacheKeyAndForwardedToOrigin parametersInCacheKeyAndForwardedToOrigin) {
            this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin;
            return this;
        }

        public CachePolicyConfig build() {
            return new CachePolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CachePolicyConfig> {
        public Builder comment(String var1);

        public Builder name(String var1);

        public Builder defaultTTL(Long var1);

        public Builder maxTTL(Long var1);

        public Builder minTTL(Long var1);

        public Builder parametersInCacheKeyAndForwardedToOrigin(ParametersInCacheKeyAndForwardedToOrigin var1);

        default public Builder parametersInCacheKeyAndForwardedToOrigin(Consumer<ParametersInCacheKeyAndForwardedToOrigin.Builder> parametersInCacheKeyAndForwardedToOrigin) {
            return this.parametersInCacheKeyAndForwardedToOrigin((ParametersInCacheKeyAndForwardedToOrigin)((ParametersInCacheKeyAndForwardedToOrigin.Builder)ParametersInCacheKeyAndForwardedToOrigin.builder().applyMutation(parametersInCacheKeyAndForwardedToOrigin)).build());
        }
    }
}

