/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OriginProtocolPolicy {
    HTTP_ONLY("http-only"),
    MATCH_VIEWER("match-viewer"),
    HTTPS_ONLY("https-only"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OriginProtocolPolicy> VALUE_MAP;
    private final String value;

    private OriginProtocolPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OriginProtocolPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OriginProtocolPolicy> knownValues() {
        EnumSet<OriginProtocolPolicy> knownValues = EnumSet.allOf(OriginProtocolPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OriginProtocolPolicy.class, OriginProtocolPolicy::toString);
    }
}

