/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginRequestPolicyCookiesConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginRequestPolicyCookiesConfig> {
    private static final SdkField<String> COOKIE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CookieBehavior").getter(OriginRequestPolicyCookiesConfig.getter(OriginRequestPolicyCookiesConfig::cookieBehaviorAsString)).setter(OriginRequestPolicyCookiesConfig.setter(Builder::cookieBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieBehavior").unmarshallLocationName("CookieBehavior").build()}).build();
    private static final SdkField<CookieNames> COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cookies").getter(OriginRequestPolicyCookiesConfig.getter(OriginRequestPolicyCookiesConfig::cookies)).setter(OriginRequestPolicyCookiesConfig.setter(Builder::cookies)).constructor(CookieNames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookies").unmarshallLocationName("Cookies").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COOKIE_BEHAVIOR_FIELD, COOKIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cookieBehavior;
    private final CookieNames cookies;

    private OriginRequestPolicyCookiesConfig(BuilderImpl builder) {
        this.cookieBehavior = builder.cookieBehavior;
        this.cookies = builder.cookies;
    }

    public final OriginRequestPolicyCookieBehavior cookieBehavior() {
        return OriginRequestPolicyCookieBehavior.fromValue(this.cookieBehavior);
    }

    public final String cookieBehaviorAsString() {
        return this.cookieBehavior;
    }

    public final CookieNames cookies() {
        return this.cookies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookies());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginRequestPolicyCookiesConfig)) {
            return false;
        }
        OriginRequestPolicyCookiesConfig other = (OriginRequestPolicyCookiesConfig)obj;
        return Objects.equals(this.cookieBehaviorAsString(), other.cookieBehaviorAsString()) && Objects.equals(this.cookies(), other.cookies());
    }

    public final String toString() {
        return ToString.builder((String)"OriginRequestPolicyCookiesConfig").add("CookieBehavior", (Object)this.cookieBehaviorAsString()).add("Cookies", (Object)this.cookies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CookieBehavior": {
                return Optional.ofNullable(clazz.cast(this.cookieBehaviorAsString()));
            }
            case "Cookies": {
                return Optional.ofNullable(clazz.cast(this.cookies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginRequestPolicyCookiesConfig, T> g) {
        return obj -> g.apply((OriginRequestPolicyCookiesConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cookieBehavior;
        private CookieNames cookies;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginRequestPolicyCookiesConfig model) {
            this.cookieBehavior(model.cookieBehavior);
            this.cookies(model.cookies);
        }

        public final String getCookieBehavior() {
            return this.cookieBehavior;
        }

        public final void setCookieBehavior(String cookieBehavior) {
            this.cookieBehavior = cookieBehavior;
        }

        @Override
        public final Builder cookieBehavior(String cookieBehavior) {
            this.cookieBehavior = cookieBehavior;
            return this;
        }

        @Override
        public final Builder cookieBehavior(OriginRequestPolicyCookieBehavior cookieBehavior) {
            this.cookieBehavior(cookieBehavior == null ? null : cookieBehavior.toString());
            return this;
        }

        public final CookieNames.Builder getCookies() {
            return this.cookies != null ? this.cookies.toBuilder() : null;
        }

        public final void setCookies(CookieNames.BuilderImpl cookies) {
            this.cookies = cookies != null ? cookies.build() : null;
        }

        @Override
        public final Builder cookies(CookieNames cookies) {
            this.cookies = cookies;
            return this;
        }

        public OriginRequestPolicyCookiesConfig build() {
            return new OriginRequestPolicyCookiesConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginRequestPolicyCookiesConfig> {
        public Builder cookieBehavior(String var1);

        public Builder cookieBehavior(OriginRequestPolicyCookieBehavior var1);

        public Builder cookies(CookieNames var1);

        default public Builder cookies(Consumer<CookieNames.Builder> cookies) {
            return this.cookies((CookieNames)((CookieNames.Builder)CookieNames.builder().applyMutation(cookies)).build());
        }
    }
}

