/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventCategory {
    INSIGHT("insight"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventCategory> VALUE_MAP;
    private final String value;

    private EventCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventCategory> knownValues() {
        EnumSet<EventCategory> knownValues = EnumSet.allOf(EventCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventCategory.class, EventCategory::toString);
    }
}

