/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.RefreshScheduleFrequency;
import software.amazon.awssdk.services.cloudtrail.model.RefreshScheduleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshSchedule> {
    private static final SdkField<RefreshScheduleFrequency> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Frequency").getter(RefreshSchedule.getter(RefreshSchedule::frequency)).setter(RefreshSchedule.setter(Builder::frequency)).constructor(RefreshScheduleFrequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RefreshSchedule.getter(RefreshSchedule::statusAsString)).setter(RefreshSchedule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TIME_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeOfDay").getter(RefreshSchedule.getter(RefreshSchedule::timeOfDay)).setter(RefreshSchedule.setter(Builder::timeOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOfDay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, STATUS_FIELD, TIME_OF_DAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RefreshSchedule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RefreshScheduleFrequency frequency;
    private final String status;
    private final String timeOfDay;

    private RefreshSchedule(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.status = builder.status;
        this.timeOfDay = builder.timeOfDay;
    }

    public final RefreshScheduleFrequency frequency() {
        return this.frequency;
    }

    public final RefreshScheduleStatus status() {
        return RefreshScheduleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String timeOfDay() {
        return this.timeOfDay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOfDay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshSchedule)) {
            return false;
        }
        RefreshSchedule other = (RefreshSchedule)obj;
        return Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.timeOfDay(), other.timeOfDay());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshSchedule").add("Frequency", (Object)this.frequency()).add("Status", (Object)this.statusAsString()).add("TimeOfDay", (Object)this.timeOfDay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TimeOfDay": {
                return Optional.ofNullable(clazz.cast(this.timeOfDay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Frequency", FREQUENCY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TimeOfDay", TIME_OF_DAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshSchedule, T> g) {
        return obj -> g.apply((RefreshSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RefreshScheduleFrequency frequency;
        private String status;
        private String timeOfDay;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshSchedule model) {
            this.frequency(model.frequency);
            this.status(model.status);
            this.timeOfDay(model.timeOfDay);
        }

        public final RefreshScheduleFrequency.Builder getFrequency() {
            return this.frequency != null ? this.frequency.toBuilder() : null;
        }

        public final void setFrequency(RefreshScheduleFrequency.BuilderImpl frequency) {
            this.frequency = frequency != null ? frequency.build() : null;
        }

        @Override
        public final Builder frequency(RefreshScheduleFrequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RefreshScheduleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTimeOfDay() {
            return this.timeOfDay;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        public RefreshSchedule build() {
            return new RefreshSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshSchedule> {
        public Builder frequency(RefreshScheduleFrequency var1);

        default public Builder frequency(Consumer<RefreshScheduleFrequency.Builder> frequency) {
            return this.frequency((RefreshScheduleFrequency)((RefreshScheduleFrequency.Builder)RefreshScheduleFrequency.builder().applyMutation(frequency)).build());
        }

        public Builder status(String var1);

        public Builder status(RefreshScheduleStatus var1);

        public Builder timeOfDay(String var1);
    }
}

