/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the default values that are used for each configuration parameter when you use <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
 * >CreateDelivery</a> to create a deliver under the current service type, resource type, and log type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationTemplateDeliveryConfigValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationTemplateDeliveryConfigValues.Builder, ConfigurationTemplateDeliveryConfigValues> {
    private static final SdkField<List<String>> RECORD_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recordFields")
            .getter(getter(ConfigurationTemplateDeliveryConfigValues::recordFields))
            .setter(setter(Builder::recordFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldDelimiter").getter(getter(ConfigurationTemplateDeliveryConfigValues::fieldDelimiter))
            .setter(setter(Builder::fieldDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDelimiter").build()).build();

    private static final SdkField<S3DeliveryConfiguration> S3_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<S3DeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3DeliveryConfiguration")
            .getter(getter(ConfigurationTemplateDeliveryConfigValues::s3DeliveryConfiguration))
            .setter(setter(Builder::s3DeliveryConfiguration)).constructor(S3DeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DeliveryConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FIELDS_FIELD,
            FIELD_DELIMITER_FIELD, S3_DELIVERY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> recordFields;

    private final String fieldDelimiter;

    private final S3DeliveryConfiguration s3DeliveryConfiguration;

    private ConfigurationTemplateDeliveryConfigValues(BuilderImpl builder) {
        this.recordFields = builder.recordFields;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.s3DeliveryConfiguration = builder.s3DeliveryConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordFields() {
        return recordFields != null && !(recordFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default record fields that will be delivered when a list of record fields is not provided in a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordFields} method.
     * </p>
     * 
     * @return The default record fields that will be delivered when a list of record fields is not provided in a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html">
     *         CreateDelivery</a> operation.
     */
    public final List<String> recordFields() {
        return recordFields;
    }

    /**
     * <p>
     * The default field delimiter that is used in a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a> operation when the field delimiter is not specified in that operation. The field delimiter is
     * used only when the final output delivery is in <code>Plain</code>, <code>W3C</code>, or <code>Raw</code> format.
     * </p>
     * 
     * @return The default field delimiter that is used in a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     *         >CreateDelivery</a> operation when the field delimiter is not specified in that operation. The field
     *         delimiter is used only when the final output delivery is in <code>Plain</code>, <code>W3C</code>, or
     *         <code>Raw</code> format.
     */
    public final String fieldDelimiter() {
        return fieldDelimiter;
    }

    /**
     * <p>
     * The delivery parameters that are used when you create a delivery to a delivery destination that is an S3 Bucket.
     * </p>
     * 
     * @return The delivery parameters that are used when you create a delivery to a delivery destination that is an S3
     *         Bucket.
     */
    public final S3DeliveryConfiguration s3DeliveryConfiguration() {
        return s3DeliveryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordFields() ? recordFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(s3DeliveryConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationTemplateDeliveryConfigValues)) {
            return false;
        }
        ConfigurationTemplateDeliveryConfigValues other = (ConfigurationTemplateDeliveryConfigValues) obj;
        return hasRecordFields() == other.hasRecordFields() && Objects.equals(recordFields(), other.recordFields())
                && Objects.equals(fieldDelimiter(), other.fieldDelimiter())
                && Objects.equals(s3DeliveryConfiguration(), other.s3DeliveryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationTemplateDeliveryConfigValues")
                .add("RecordFields", hasRecordFields() ? recordFields() : null).add("FieldDelimiter", fieldDelimiter())
                .add("S3DeliveryConfiguration", s3DeliveryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordFields":
            return Optional.ofNullable(clazz.cast(recordFields()));
        case "fieldDelimiter":
            return Optional.ofNullable(clazz.cast(fieldDelimiter()));
        case "s3DeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(s3DeliveryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationTemplateDeliveryConfigValues, T> g) {
        return obj -> g.apply((ConfigurationTemplateDeliveryConfigValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationTemplateDeliveryConfigValues> {
        /**
         * <p>
         * The default record fields that will be delivered when a list of record fields is not provided in a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> operation.
         * </p>
         * 
         * @param recordFields
         *        The default record fields that will be delivered when a list of record fields is not provided in a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html">
         *        CreateDelivery</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordFields(Collection<String> recordFields);

        /**
         * <p>
         * The default record fields that will be delivered when a list of record fields is not provided in a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> operation.
         * </p>
         * 
         * @param recordFields
         *        The default record fields that will be delivered when a list of record fields is not provided in a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html">
         *        CreateDelivery</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordFields(String... recordFields);

        /**
         * <p>
         * The default field delimiter that is used in a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> operation when the field delimiter is not specified in that operation. The field
         * delimiter is used only when the final output delivery is in <code>Plain</code>, <code>W3C</code>, or
         * <code>Raw</code> format.
         * </p>
         * 
         * @param fieldDelimiter
         *        The default field delimiter that is used in a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> operation when the field delimiter is not specified in that operation. The field
         *        delimiter is used only when the final output delivery is in <code>Plain</code>, <code>W3C</code>, or
         *        <code>Raw</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDelimiter(String fieldDelimiter);

        /**
         * <p>
         * The delivery parameters that are used when you create a delivery to a delivery destination that is an S3
         * Bucket.
         * </p>
         * 
         * @param s3DeliveryConfiguration
         *        The delivery parameters that are used when you create a delivery to a delivery destination that is an
         *        S3 Bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DeliveryConfiguration(S3DeliveryConfiguration s3DeliveryConfiguration);

        /**
         * <p>
         * The delivery parameters that are used when you create a delivery to a delivery destination that is an S3
         * Bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DeliveryConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3DeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DeliveryConfiguration(S3DeliveryConfiguration)}.
         * 
         * @param s3DeliveryConfiguration
         *        a consumer that will call methods on {@link S3DeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DeliveryConfiguration(S3DeliveryConfiguration)
         */
        default Builder s3DeliveryConfiguration(Consumer<S3DeliveryConfiguration.Builder> s3DeliveryConfiguration) {
            return s3DeliveryConfiguration(S3DeliveryConfiguration.builder().applyMutation(s3DeliveryConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> recordFields = DefaultSdkAutoConstructList.getInstance();

        private String fieldDelimiter;

        private S3DeliveryConfiguration s3DeliveryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationTemplateDeliveryConfigValues model) {
            recordFields(model.recordFields);
            fieldDelimiter(model.fieldDelimiter);
            s3DeliveryConfiguration(model.s3DeliveryConfiguration);
        }

        public final Collection<String> getRecordFields() {
            if (recordFields instanceof SdkAutoConstructList) {
                return null;
            }
            return recordFields;
        }

        public final void setRecordFields(Collection<String> recordFields) {
            this.recordFields = RecordFieldsCopier.copy(recordFields);
        }

        @Override
        public final Builder recordFields(Collection<String> recordFields) {
            this.recordFields = RecordFieldsCopier.copy(recordFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordFields(String... recordFields) {
            recordFields(Arrays.asList(recordFields));
            return this;
        }

        public final String getFieldDelimiter() {
            return fieldDelimiter;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final S3DeliveryConfiguration.Builder getS3DeliveryConfiguration() {
            return s3DeliveryConfiguration != null ? s3DeliveryConfiguration.toBuilder() : null;
        }

        public final void setS3DeliveryConfiguration(S3DeliveryConfiguration.BuilderImpl s3DeliveryConfiguration) {
            this.s3DeliveryConfiguration = s3DeliveryConfiguration != null ? s3DeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder s3DeliveryConfiguration(S3DeliveryConfiguration s3DeliveryConfiguration) {
            this.s3DeliveryConfiguration = s3DeliveryConfiguration;
            return this;
        }

        @Override
        public ConfigurationTemplateDeliveryConfigValues build() {
            return new ConfigurationTemplateDeliveryConfigValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
