/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLogAnomalyDetectorRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<UpdateLogAnomalyDetectorRequest.Builder, UpdateLogAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyDetectorArn").getter(getter(UpdateLogAnomalyDetectorRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build())
            .build();

    private static final SdkField<String> EVALUATION_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationFrequency").getter(getter(UpdateLogAnomalyDetectorRequest::evaluationFrequencyAsString))
            .setter(setter(Builder::evaluationFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationFrequency").build())
            .build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(UpdateLogAnomalyDetectorRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<Long> ANOMALY_VISIBILITY_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("anomalyVisibilityTime").getter(getter(UpdateLogAnomalyDetectorRequest::anomalyVisibilityTime))
            .setter(setter(Builder::anomalyVisibilityTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyVisibilityTime").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(UpdateLogAnomalyDetectorRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            EVALUATION_FREQUENCY_FIELD, FILTER_PATTERN_FIELD, ANOMALY_VISIBILITY_TIME_FIELD, ENABLED_FIELD));

    private final String anomalyDetectorArn;

    private final String evaluationFrequency;

    private final String filterPattern;

    private final Long anomalyVisibilityTime;

    private final Boolean enabled;

    private UpdateLogAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.evaluationFrequency = builder.evaluationFrequency;
        this.filterPattern = builder.filterPattern;
        this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ARN of the anomaly detector that you want to update.
     * </p>
     * 
     * @return The ARN of the anomaly detector that you want to update.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the frequency
     * that the log group receives new logs. For example, if the log group receives new log events every 10 minutes,
     * then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationFrequency} will return {@link EvaluationFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
     *         frequency that the log group receives new logs. For example, if the log group receives new log events
     *         every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
     *         appropriate.
     * @see EvaluationFrequency
     */
    public final EvaluationFrequency evaluationFrequency() {
        return EvaluationFrequency.fromValue(evaluationFrequency);
    }

    /**
     * <p>
     * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the frequency
     * that the log group receives new logs. For example, if the log group receives new log events every 10 minutes,
     * then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationFrequency} will return {@link EvaluationFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
     *         frequency that the log group receives new logs. For example, if the log group receives new log events
     *         every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
     *         appropriate.
     * @see EvaluationFrequency
     */
    public final String evaluationFrequencyAsString() {
        return evaluationFrequency;
    }

    /**
     * Returns the value of the FilterPattern property for this object.
     * 
     * @return The value of the FilterPattern property for this object.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The number of days to use as the life cycle of anomalies. After this time, anomalies are automatically baselined
     * and the anomaly detector model will treat new occurrences of similar event as normal. Therefore, if you do not
     * correct the cause of an anomaly during this time, it will be considered normal going forward and will not be
     * detected.
     * </p>
     * 
     * @return The number of days to use as the life cycle of anomalies. After this time, anomalies are automatically
     *         baselined and the anomaly detector model will treat new occurrences of similar event as normal.
     *         Therefore, if you do not correct the cause of an anomaly during this time, it will be considered normal
     *         going forward and will not be detected.
     */
    public final Long anomalyVisibilityTime() {
        return anomalyVisibilityTime;
    }

    /**
     * <p>
     * Use this parameter to pause or restart the anomaly detector.
     * </p>
     * 
     * @return Use this parameter to pause or restart the anomaly detector.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyVisibilityTime());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLogAnomalyDetectorRequest)) {
            return false;
        }
        UpdateLogAnomalyDetectorRequest other = (UpdateLogAnomalyDetectorRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(evaluationFrequencyAsString(), other.evaluationFrequencyAsString())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(anomalyVisibilityTime(), other.anomalyVisibilityTime())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLogAnomalyDetectorRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("EvaluationFrequency", evaluationFrequencyAsString()).add("FilterPattern", filterPattern())
                .add("AnomalyVisibilityTime", anomalyVisibilityTime()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "evaluationFrequency":
            return Optional.ofNullable(clazz.cast(evaluationFrequencyAsString()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "anomalyVisibilityTime":
            return Optional.ofNullable(clazz.cast(anomalyVisibilityTime()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLogAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((UpdateLogAnomalyDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLogAnomalyDetectorRequest> {
        /**
         * <p>
         * The ARN of the anomaly detector that you want to update.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the anomaly detector that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         * frequency that the log group receives new logs. For example, if the log group receives new log events every
         * 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
         * </p>
         * 
         * @param evaluationFrequency
         *        Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         *        frequency that the log group receives new logs. For example, if the log group receives new log events
         *        every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
         *        appropriate.
         * @see EvaluationFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFrequency
         */
        Builder evaluationFrequency(String evaluationFrequency);

        /**
         * <p>
         * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         * frequency that the log group receives new logs. For example, if the log group receives new log events every
         * 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
         * </p>
         * 
         * @param evaluationFrequency
         *        Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         *        frequency that the log group receives new logs. For example, if the log group receives new log events
         *        every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
         *        appropriate.
         * @see EvaluationFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFrequency
         */
        Builder evaluationFrequency(EvaluationFrequency evaluationFrequency);

        /**
         * Sets the value of the FilterPattern property for this object.
         *
         * @param filterPattern
         *        The new value for the FilterPattern property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The number of days to use as the life cycle of anomalies. After this time, anomalies are automatically
         * baselined and the anomaly detector model will treat new occurrences of similar event as normal. Therefore, if
         * you do not correct the cause of an anomaly during this time, it will be considered normal going forward and
         * will not be detected.
         * </p>
         * 
         * @param anomalyVisibilityTime
         *        The number of days to use as the life cycle of anomalies. After this time, anomalies are automatically
         *        baselined and the anomaly detector model will treat new occurrences of similar event as normal.
         *        Therefore, if you do not correct the cause of an anomaly during this time, it will be considered
         *        normal going forward and will not be detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyVisibilityTime(Long anomalyVisibilityTime);

        /**
         * <p>
         * Use this parameter to pause or restart the anomaly detector.
         * </p>
         * 
         * @param enabled
         *        Use this parameter to pause or restart the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String evaluationFrequency;

        private String filterPattern;

        private Long anomalyVisibilityTime;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLogAnomalyDetectorRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            evaluationFrequency(model.evaluationFrequency);
            filterPattern(model.filterPattern);
            anomalyVisibilityTime(model.anomalyVisibilityTime);
            enabled(model.enabled);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getEvaluationFrequency() {
            return evaluationFrequency;
        }

        public final void setEvaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
        }

        @Override
        public final Builder evaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        @Override
        public final Builder evaluationFrequency(EvaluationFrequency evaluationFrequency) {
            this.evaluationFrequency(evaluationFrequency == null ? null : evaluationFrequency.toString());
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final Long getAnomalyVisibilityTime() {
            return anomalyVisibilityTime;
        }

        public final void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
        }

        @Override
        public final Builder anomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLogAnomalyDetectorRequest build() {
            return new UpdateLogAnomalyDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
