/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutQueryDefinitionRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutQueryDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PutQueryDefinitionRequest.getter(PutQueryDefinitionRequest::name)).setter(PutQueryDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> QUERY_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryDefinitionId").getter(PutQueryDefinitionRequest.getter(PutQueryDefinitionRequest::queryDefinitionId)).setter(PutQueryDefinitionRequest.setter(Builder::queryDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitionId").build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupNames").getter(PutQueryDefinitionRequest.getter(PutQueryDefinitionRequest::logGroupNames)).setter(PutQueryDefinitionRequest.setter(Builder::logGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(PutQueryDefinitionRequest.getter(PutQueryDefinitionRequest::queryString)).setter(PutQueryDefinitionRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(PutQueryDefinitionRequest.getter(PutQueryDefinitionRequest::clientToken)).setter(PutQueryDefinitionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, QUERY_DEFINITION_ID_FIELD, LOG_GROUP_NAMES_FIELD, QUERY_STRING_FIELD, CLIENT_TOKEN_FIELD));
    private final String name;
    private final String queryDefinitionId;
    private final List<String> logGroupNames;
    private final String queryString;
    private final String clientToken;

    private PutQueryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.queryDefinitionId = builder.queryDefinitionId;
        this.logGroupNames = builder.logGroupNames;
        this.queryString = builder.queryString;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String queryDefinitionId() {
        return this.queryDefinitionId;
    }

    public final boolean hasLogGroupNames() {
        return this.logGroupNames != null && !(this.logGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupNames() {
        return this.logGroupNames;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupNames() ? this.logGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutQueryDefinitionRequest)) {
            return false;
        }
        PutQueryDefinitionRequest other = (PutQueryDefinitionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.queryDefinitionId(), other.queryDefinitionId()) && this.hasLogGroupNames() == other.hasLogGroupNames() && Objects.equals(this.logGroupNames(), other.logGroupNames()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutQueryDefinitionRequest").add("Name", (Object)this.name()).add("QueryDefinitionId", (Object)this.queryDefinitionId()).add("LogGroupNames", this.hasLogGroupNames() ? this.logGroupNames() : null).add("QueryString", (Object)this.queryString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "queryDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.queryDefinitionId()));
            }
            case "logGroupNames": {
                return Optional.ofNullable(clazz.cast(this.logGroupNames()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutQueryDefinitionRequest, T> g) {
        return obj -> g.apply((PutQueryDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String queryDefinitionId;
        private List<String> logGroupNames = DefaultSdkAutoConstructList.getInstance();
        private String queryString;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutQueryDefinitionRequest model) {
            super(model);
            this.name(model.name);
            this.queryDefinitionId(model.queryDefinitionId);
            this.logGroupNames(model.logGroupNames);
            this.queryString(model.queryString);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueryDefinitionId() {
            return this.queryDefinitionId;
        }

        public final void setQueryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
        }

        @Override
        public final Builder queryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
            return this;
        }

        public final Collection<String> getLogGroupNames() {
            if (this.logGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupNames;
        }

        public final void setLogGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
        }

        @Override
        public final Builder logGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupNames(String ... logGroupNames) {
            this.logGroupNames(Arrays.asList(logGroupNames));
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutQueryDefinitionRequest build() {
            return new PutQueryDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutQueryDefinitionRequest> {
        public Builder name(String var1);

        public Builder queryDefinitionId(String var1);

        public Builder logGroupNames(Collection<String> var1);

        public Builder logGroupNames(String ... var1);

        public Builder queryString(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

