/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse;

public class ListBuildBatchesForProjectIterable
implements SdkIterable<ListBuildBatchesForProjectResponse> {
    private final CodeBuildClient client;
    private final ListBuildBatchesForProjectRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBuildBatchesForProjectIterable(CodeBuildClient client, ListBuildBatchesForProjectRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBuildBatchesForProjectResponseFetcher();
    }

    public Iterator<ListBuildBatchesForProjectResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<ListBuildBatchesForProjectResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBuildBatchesForProjectResponseFetcher
    implements SyncPageFetcher<ListBuildBatchesForProjectResponse> {
        private ListBuildBatchesForProjectResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildBatchesForProjectResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBuildBatchesForProjectResponse nextPage(ListBuildBatchesForProjectResponse previousPage) {
            if (previousPage == null) {
                return ListBuildBatchesForProjectIterable.this.client.listBuildBatchesForProject(ListBuildBatchesForProjectIterable.this.firstRequest);
            }
            return ListBuildBatchesForProjectIterable.this.client.listBuildBatchesForProject((ListBuildBatchesForProjectRequest)((Object)ListBuildBatchesForProjectIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

