/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse;

public class ListReportGroupsIterable
implements SdkIterable<ListReportGroupsResponse> {
    private final CodeBuildClient client;
    private final ListReportGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportGroupsIterable(CodeBuildClient client, ListReportGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReportGroupsResponseFetcher();
    }

    public Iterator<ListReportGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> reportGroups() {
        Function<ListReportGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reportGroups() != null) {
                return response.reportGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReportGroupsResponseFetcher
    implements SyncPageFetcher<ListReportGroupsResponse> {
        private ListReportGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportGroupsResponse nextPage(ListReportGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListReportGroupsIterable.this.client.listReportGroups(ListReportGroupsIterable.this.firstRequest);
            }
            return ListReportGroupsIterable.this.client.listReportGroups((ListReportGroupsRequest)((Object)ListReportGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

