/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about deployments related to the specified deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedDeployments implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedDeployments.Builder, RelatedDeployments> {
    private static final SdkField<String> AUTO_UPDATE_OUTDATED_INSTANCES_ROOT_DEPLOYMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("autoUpdateOutdatedInstancesRootDeploymentId")
            .getter(getter(RelatedDeployments::autoUpdateOutdatedInstancesRootDeploymentId))
            .setter(setter(Builder::autoUpdateOutdatedInstancesRootDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("autoUpdateOutdatedInstancesRootDeploymentId").build()).build();

    private static final SdkField<List<String>> AUTO_UPDATE_OUTDATED_INSTANCES_DEPLOYMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoUpdateOutdatedInstancesDeploymentIds")
            .getter(getter(RelatedDeployments::autoUpdateOutdatedInstancesDeploymentIds))
            .setter(setter(Builder::autoUpdateOutdatedInstancesDeploymentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("autoUpdateOutdatedInstancesDeploymentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_UPDATE_OUTDATED_INSTANCES_ROOT_DEPLOYMENT_ID_FIELD, AUTO_UPDATE_OUTDATED_INSTANCES_DEPLOYMENT_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoUpdateOutdatedInstancesRootDeploymentId;

    private final List<String> autoUpdateOutdatedInstancesDeploymentIds;

    private RelatedDeployments(BuilderImpl builder) {
        this.autoUpdateOutdatedInstancesRootDeploymentId = builder.autoUpdateOutdatedInstancesRootDeploymentId;
        this.autoUpdateOutdatedInstancesDeploymentIds = builder.autoUpdateOutdatedInstancesDeploymentIds;
    }

    /**
     * <p>
     * The deployment ID of the root deployment that triggered this deployment.
     * </p>
     * 
     * @return The deployment ID of the root deployment that triggered this deployment.
     */
    public final String autoUpdateOutdatedInstancesRootDeploymentId() {
        return autoUpdateOutdatedInstancesRootDeploymentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoUpdateOutdatedInstancesDeploymentIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAutoUpdateOutdatedInstancesDeploymentIds() {
        return autoUpdateOutdatedInstancesDeploymentIds != null
                && !(autoUpdateOutdatedInstancesDeploymentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasAutoUpdateOutdatedInstancesDeploymentIds} method.
     * </p>
     * 
     * @return The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.
     */
    public final List<String> autoUpdateOutdatedInstancesDeploymentIds() {
        return autoUpdateOutdatedInstancesDeploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdateOutdatedInstancesRootDeploymentId());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasAutoUpdateOutdatedInstancesDeploymentIds() ? autoUpdateOutdatedInstancesDeploymentIds()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedDeployments)) {
            return false;
        }
        RelatedDeployments other = (RelatedDeployments) obj;
        return Objects.equals(autoUpdateOutdatedInstancesRootDeploymentId(), other.autoUpdateOutdatedInstancesRootDeploymentId())
                && hasAutoUpdateOutdatedInstancesDeploymentIds() == other.hasAutoUpdateOutdatedInstancesDeploymentIds()
                && Objects.equals(autoUpdateOutdatedInstancesDeploymentIds(), other.autoUpdateOutdatedInstancesDeploymentIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("RelatedDeployments")
                .add("AutoUpdateOutdatedInstancesRootDeploymentId", autoUpdateOutdatedInstancesRootDeploymentId())
                .add("AutoUpdateOutdatedInstancesDeploymentIds",
                        hasAutoUpdateOutdatedInstancesDeploymentIds() ? autoUpdateOutdatedInstancesDeploymentIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoUpdateOutdatedInstancesRootDeploymentId":
            return Optional.ofNullable(clazz.cast(autoUpdateOutdatedInstancesRootDeploymentId()));
        case "autoUpdateOutdatedInstancesDeploymentIds":
            return Optional.ofNullable(clazz.cast(autoUpdateOutdatedInstancesDeploymentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedDeployments, T> g) {
        return obj -> g.apply((RelatedDeployments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedDeployments> {
        /**
         * <p>
         * The deployment ID of the root deployment that triggered this deployment.
         * </p>
         * 
         * @param autoUpdateOutdatedInstancesRootDeploymentId
         *        The deployment ID of the root deployment that triggered this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdateOutdatedInstancesRootDeploymentId(String autoUpdateOutdatedInstancesRootDeploymentId);

        /**
         * <p>
         * The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.
         * </p>
         * 
         * @param autoUpdateOutdatedInstancesDeploymentIds
         *        The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdateOutdatedInstancesDeploymentIds(Collection<String> autoUpdateOutdatedInstancesDeploymentIds);

        /**
         * <p>
         * The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.
         * </p>
         * 
         * @param autoUpdateOutdatedInstancesDeploymentIds
         *        The deployment IDs of 'auto-update outdated instances' deployments triggered by this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdateOutdatedInstancesDeploymentIds(String... autoUpdateOutdatedInstancesDeploymentIds);
    }

    static final class BuilderImpl implements Builder {
        private String autoUpdateOutdatedInstancesRootDeploymentId;

        private List<String> autoUpdateOutdatedInstancesDeploymentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedDeployments model) {
            autoUpdateOutdatedInstancesRootDeploymentId(model.autoUpdateOutdatedInstancesRootDeploymentId);
            autoUpdateOutdatedInstancesDeploymentIds(model.autoUpdateOutdatedInstancesDeploymentIds);
        }

        public final String getAutoUpdateOutdatedInstancesRootDeploymentId() {
            return autoUpdateOutdatedInstancesRootDeploymentId;
        }

        public final void setAutoUpdateOutdatedInstancesRootDeploymentId(String autoUpdateOutdatedInstancesRootDeploymentId) {
            this.autoUpdateOutdatedInstancesRootDeploymentId = autoUpdateOutdatedInstancesRootDeploymentId;
        }

        @Override
        public final Builder autoUpdateOutdatedInstancesRootDeploymentId(String autoUpdateOutdatedInstancesRootDeploymentId) {
            this.autoUpdateOutdatedInstancesRootDeploymentId = autoUpdateOutdatedInstancesRootDeploymentId;
            return this;
        }

        public final Collection<String> getAutoUpdateOutdatedInstancesDeploymentIds() {
            if (autoUpdateOutdatedInstancesDeploymentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return autoUpdateOutdatedInstancesDeploymentIds;
        }

        public final void setAutoUpdateOutdatedInstancesDeploymentIds(Collection<String> autoUpdateOutdatedInstancesDeploymentIds) {
            this.autoUpdateOutdatedInstancesDeploymentIds = DeploymentsListCopier.copy(autoUpdateOutdatedInstancesDeploymentIds);
        }

        @Override
        public final Builder autoUpdateOutdatedInstancesDeploymentIds(Collection<String> autoUpdateOutdatedInstancesDeploymentIds) {
            this.autoUpdateOutdatedInstancesDeploymentIds = DeploymentsListCopier.copy(autoUpdateOutdatedInstancesDeploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoUpdateOutdatedInstancesDeploymentIds(String... autoUpdateOutdatedInstancesDeploymentIds) {
            autoUpdateOutdatedInstancesDeploymentIds(Arrays.asList(autoUpdateOutdatedInstancesDeploymentIds));
            return this;
        }

        @Override
        public RelatedDeployments build() {
            return new RelatedDeployments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
