/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the BatchGetFrameMetricDataResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFrameMetricDataResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<BatchGetFrameMetricDataResponse.Builder, BatchGetFrameMetricDataResponse> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(BatchGetFrameMetricDataResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<TimestampStructure>> END_TIMES_FIELD = SdkField
            .<List<TimestampStructure>> builder(MarshallingType.LIST)
            .memberName("endTimes")
            .getter(getter(BatchGetFrameMetricDataResponse::endTimes))
            .setter(setter(Builder::endTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimestampStructure> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimestampStructure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FrameMetricDatum>> FRAME_METRIC_DATA_FIELD = SdkField
            .<List<FrameMetricDatum>> builder(MarshallingType.LIST)
            .memberName("frameMetricData")
            .getter(getter(BatchGetFrameMetricDataResponse::frameMetricData))
            .setter(setter(Builder::frameMetricData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetricData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FrameMetricDatum> builder(MarshallingType.SDK_POJO)
                                            .constructor(FrameMetricDatum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolution").getter(getter(BatchGetFrameMetricDataResponse::resolutionAsString))
            .setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(BatchGetFrameMetricDataResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, List<TimestampStructure>>> UNPROCESSED_END_TIMES_FIELD = SdkField
            .<Map<String, List<TimestampStructure>>> builder(MarshallingType.MAP)
            .memberName("unprocessedEndTimes")
            .getter(getter(BatchGetFrameMetricDataResponse::unprocessedEndTimes))
            .setter(setter(Builder::unprocessedEndTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedEndTimes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<TimestampStructure>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<TimestampStructure> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(TimestampStructure::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            END_TIMES_FIELD, FRAME_METRIC_DATA_FIELD, RESOLUTION_FIELD, START_TIME_FIELD, UNPROCESSED_END_TIMES_FIELD));

    private final Instant endTime;

    private final List<TimestampStructure> endTimes;

    private final List<FrameMetricDatum> frameMetricData;

    private final String resolution;

    private final Instant startTime;

    private final Map<String, List<TimestampStructure>> unprocessedEndTimes;

    private BatchGetFrameMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.endTimes = builder.endTimes;
        this.frameMetricData = builder.frameMetricData;
        this.resolution = builder.resolution;
        this.startTime = builder.startTime;
        this.unprocessedEndTimes = builder.unprocessedEndTimes;
    }

    /**
     * <p>
     * The end time of the time period for the returned time series values. This is specified using the ISO 8601 format.
     * For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the time period for the returned time series values. This is specified using the ISO 8601
     *         format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndTimes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndTimes() {
        return endTimes != null && !(endTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of instances, or time steps, in the time series. For example, if the <code>period</code> is one day (
     * <code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then there are 288
     * <code>endTimes</code> in the list that are each five minutes appart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndTimes} method.
     * </p>
     * 
     * @return List of instances, or time steps, in the time series. For example, if the <code>period</code> is one day
     *         (<code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then there
     *         are 288 <code>endTimes</code> in the list that are each five minutes appart.
     */
    public final List<TimestampStructure> endTimes() {
        return endTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the FrameMetricData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFrameMetricData() {
        return frameMetricData != null && !(frameMetricData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the metrics to request a time series of values. The metric includes the name of the frame, the
     * aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for
     * the metric value of the frame.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameMetricData} method.
     * </p>
     * 
     * @return Details of the metrics to request a time series of values. The metric includes the name of the frame, the
     *         aggregation type to calculate the metric value for the frame, and the thread states to use to get the
     *         count for the metric value of the frame.
     */
    public final List<FrameMetricDatum> frameMetricData() {
        return frameMetricData;
    }

    /**
     * <p>
     * Resolution or granularity of the profile data used to generate the time series. This is the value used to jump
     * through time steps in a time series. There are 3 valid values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P1D</code> — 1 day
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT1H</code> — 1 hour
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT5M</code> — 5 minutes
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return Resolution or granularity of the profile data used to generate the time series. This is the value used to
     *         jump through time steps in a time series. There are 3 valid values. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P1D</code> — 1 day
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT1H</code> — 1 hour
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT5M</code> — 5 minutes
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final AggregationPeriod resolution() {
        return AggregationPeriod.fromValue(resolution);
    }

    /**
     * <p>
     * Resolution or granularity of the profile data used to generate the time series. This is the value used to jump
     * through time steps in a time series. There are 3 valid values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P1D</code> — 1 day
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT1H</code> — 1 hour
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT5M</code> — 5 minutes
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return Resolution or granularity of the profile data used to generate the time series. This is the value used to
     *         jump through time steps in a time series. There are 3 valid values. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P1D</code> — 1 day
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT1H</code> — 1 hour
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT5M</code> — 5 minutes
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final String resolutionAsString() {
        return resolution;
    }

    /**
     * <p>
     * The start time of the time period for the returned time series values. This is specified using the ISO 8601
     * format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the time period for the returned time series values. This is specified using the ISO
     *         8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM
     *         UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedEndTimes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedEndTimes() {
        return unprocessedEndTimes != null && !(unprocessedEndTimes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedEndTimes} method.
     * </p>
     * 
     * @return List of instances which remained unprocessed. This will create a missing time step in the list of end
     *         times.
     */
    public final Map<String, List<TimestampStructure>> unprocessedEndTimes() {
        return unprocessedEndTimes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndTimes() ? endTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameMetricData() ? frameMetricData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedEndTimes() ? unprocessedEndTimes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFrameMetricDataResponse)) {
            return false;
        }
        BatchGetFrameMetricDataResponse other = (BatchGetFrameMetricDataResponse) obj;
        return Objects.equals(endTime(), other.endTime()) && hasEndTimes() == other.hasEndTimes()
                && Objects.equals(endTimes(), other.endTimes()) && hasFrameMetricData() == other.hasFrameMetricData()
                && Objects.equals(frameMetricData(), other.frameMetricData())
                && Objects.equals(resolutionAsString(), other.resolutionAsString())
                && Objects.equals(startTime(), other.startTime()) && hasUnprocessedEndTimes() == other.hasUnprocessedEndTimes()
                && Objects.equals(unprocessedEndTimes(), other.unprocessedEndTimes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFrameMetricDataResponse").add("EndTime", endTime())
                .add("EndTimes", hasEndTimes() ? endTimes() : null)
                .add("FrameMetricData", hasFrameMetricData() ? frameMetricData() : null).add("Resolution", resolutionAsString())
                .add("StartTime", startTime())
                .add("UnprocessedEndTimes", hasUnprocessedEndTimes() ? unprocessedEndTimes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "endTimes":
            return Optional.ofNullable(clazz.cast(endTimes()));
        case "frameMetricData":
            return Optional.ofNullable(clazz.cast(frameMetricData()));
        case "resolution":
            return Optional.ofNullable(clazz.cast(resolutionAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "unprocessedEndTimes":
            return Optional.ofNullable(clazz.cast(unprocessedEndTimes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFrameMetricDataResponse, T> g) {
        return obj -> g.apply((BatchGetFrameMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetFrameMetricDataResponse> {
        /**
         * <p>
         * The end time of the time period for the returned time series values. This is specified using the ISO 8601
         * format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param endTime
         *        The end time of the time period for the returned time series values. This is specified using the ISO
         *        8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
         *        PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * List of instances, or time steps, in the time series. For example, if the <code>period</code> is one day (
         * <code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then there are 288
         * <code>endTimes</code> in the list that are each five minutes appart.
         * </p>
         * 
         * @param endTimes
         *        List of instances, or time steps, in the time series. For example, if the <code>period</code> is one
         *        day (<code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then
         *        there are 288 <code>endTimes</code> in the list that are each five minutes appart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimes(Collection<TimestampStructure> endTimes);

        /**
         * <p>
         * List of instances, or time steps, in the time series. For example, if the <code>period</code> is one day (
         * <code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then there are 288
         * <code>endTimes</code> in the list that are each five minutes appart.
         * </p>
         * 
         * @param endTimes
         *        List of instances, or time steps, in the time series. For example, if the <code>period</code> is one
         *        day (<code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then
         *        there are 288 <code>endTimes</code> in the list that are each five minutes appart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimes(TimestampStructure... endTimes);

        /**
         * <p>
         * List of instances, or time steps, in the time series. For example, if the <code>period</code> is one day (
         * <code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then there are 288
         * <code>endTimes</code> in the list that are each five minutes appart.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TimestampStructure>.Builder}
         * avoiding the need to create one manually via {@link List<TimestampStructure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TimestampStructure>.Builder#build()} is called immediately
         * and its result is passed to {@link #endTimes(List<TimestampStructure>)}.
         * 
         * @param endTimes
         *        a consumer that will call methods on {@link List<TimestampStructure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTimes(List<TimestampStructure>)
         */
        Builder endTimes(Consumer<TimestampStructure.Builder>... endTimes);

        /**
         * <p>
         * Details of the metrics to request a time series of values. The metric includes the name of the frame, the
         * aggregation type to calculate the metric value for the frame, and the thread states to use to get the count
         * for the metric value of the frame.
         * </p>
         * 
         * @param frameMetricData
         *        Details of the metrics to request a time series of values. The metric includes the name of the frame,
         *        the aggregation type to calculate the metric value for the frame, and the thread states to use to get
         *        the count for the metric value of the frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameMetricData(Collection<FrameMetricDatum> frameMetricData);

        /**
         * <p>
         * Details of the metrics to request a time series of values. The metric includes the name of the frame, the
         * aggregation type to calculate the metric value for the frame, and the thread states to use to get the count
         * for the metric value of the frame.
         * </p>
         * 
         * @param frameMetricData
         *        Details of the metrics to request a time series of values. The metric includes the name of the frame,
         *        the aggregation type to calculate the metric value for the frame, and the thread states to use to get
         *        the count for the metric value of the frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameMetricData(FrameMetricDatum... frameMetricData);

        /**
         * <p>
         * Details of the metrics to request a time series of values. The metric includes the name of the frame, the
         * aggregation type to calculate the metric value for the frame, and the thread states to use to get the count
         * for the metric value of the frame.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FrameMetricDatum>.Builder} avoiding
         * the need to create one manually via {@link List<FrameMetricDatum>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FrameMetricDatum>.Builder#build()} is called immediately and
         * its result is passed to {@link #frameMetricData(List<FrameMetricDatum>)}.
         * 
         * @param frameMetricData
         *        a consumer that will call methods on {@link List<FrameMetricDatum>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameMetricData(List<FrameMetricDatum>)
         */
        Builder frameMetricData(Consumer<FrameMetricDatum.Builder>... frameMetricData);

        /**
         * <p>
         * Resolution or granularity of the profile data used to generate the time series. This is the value used to
         * jump through time steps in a time series. There are 3 valid values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P1D</code> — 1 day
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT1H</code> — 1 hour
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT5M</code> — 5 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param resolution
         *        Resolution or granularity of the profile data used to generate the time series. This is the value used
         *        to jump through time steps in a time series. There are 3 valid values. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P1D</code> — 1 day
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT1H</code> — 1 hour
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT5M</code> — 5 minutes
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder resolution(String resolution);

        /**
         * <p>
         * Resolution or granularity of the profile data used to generate the time series. This is the value used to
         * jump through time steps in a time series. There are 3 valid values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P1D</code> — 1 day
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT1H</code> — 1 hour
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT5M</code> — 5 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param resolution
         *        Resolution or granularity of the profile data used to generate the time series. This is the value used
         *        to jump through time steps in a time series. There are 3 valid values. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P1D</code> — 1 day
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT1H</code> — 1 hour
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT5M</code> — 5 minutes
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder resolution(AggregationPeriod resolution);

        /**
         * <p>
         * The start time of the time period for the returned time series values. This is specified using the ISO 8601
         * format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param startTime
         *        The start time of the time period for the returned time series values. This is specified using the ISO
         *        8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
         *        PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
         * </p>
         * 
         * @param unprocessedEndTimes
         *        List of instances which remained unprocessed. This will create a missing time step in the list of end
         *        times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedEndTimes(Map<String, ? extends Collection<TimestampStructure>> unprocessedEndTimes);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private Instant endTime;

        private List<TimestampStructure> endTimes = DefaultSdkAutoConstructList.getInstance();

        private List<FrameMetricDatum> frameMetricData = DefaultSdkAutoConstructList.getInstance();

        private String resolution;

        private Instant startTime;

        private Map<String, List<TimestampStructure>> unprocessedEndTimes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFrameMetricDataResponse model) {
            super(model);
            endTime(model.endTime);
            endTimes(model.endTimes);
            frameMetricData(model.frameMetricData);
            resolution(model.resolution);
            startTime(model.startTime);
            unprocessedEndTimes(model.unprocessedEndTimes);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<TimestampStructure.Builder> getEndTimes() {
            List<TimestampStructure.Builder> result = ListOfTimestampsCopier.copyToBuilder(this.endTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndTimes(Collection<TimestampStructure.BuilderImpl> endTimes) {
            this.endTimes = ListOfTimestampsCopier.copyFromBuilder(endTimes);
        }

        @Override
        public final Builder endTimes(Collection<TimestampStructure> endTimes) {
            this.endTimes = ListOfTimestampsCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(TimestampStructure... endTimes) {
            endTimes(Arrays.asList(endTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(Consumer<TimestampStructure.Builder>... endTimes) {
            endTimes(Stream.of(endTimes).map(c -> TimestampStructure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FrameMetricDatum.Builder> getFrameMetricData() {
            List<FrameMetricDatum.Builder> result = FrameMetricDataCopier.copyToBuilder(this.frameMetricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameMetricData(Collection<FrameMetricDatum.BuilderImpl> frameMetricData) {
            this.frameMetricData = FrameMetricDataCopier.copyFromBuilder(frameMetricData);
        }

        @Override
        public final Builder frameMetricData(Collection<FrameMetricDatum> frameMetricData) {
            this.frameMetricData = FrameMetricDataCopier.copy(frameMetricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameMetricData(FrameMetricDatum... frameMetricData) {
            frameMetricData(Arrays.asList(frameMetricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameMetricData(Consumer<FrameMetricDatum.Builder>... frameMetricData) {
            frameMetricData(Stream.of(frameMetricData).map(c -> FrameMetricDatum.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResolution() {
            return resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(AggregationPeriod resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Map<String, List<TimestampStructure.Builder>> getUnprocessedEndTimes() {
            Map<String, List<TimestampStructure.Builder>> result = UnprocessedEndTimeMapCopier
                    .copyToBuilder(this.unprocessedEndTimes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedEndTimes(
                Map<String, ? extends Collection<TimestampStructure.BuilderImpl>> unprocessedEndTimes) {
            this.unprocessedEndTimes = UnprocessedEndTimeMapCopier.copyFromBuilder(unprocessedEndTimes);
        }

        @Override
        public final Builder unprocessedEndTimes(Map<String, ? extends Collection<TimestampStructure>> unprocessedEndTimes) {
            this.unprocessedEndTimes = UnprocessedEndTimeMapCopier.copy(unprocessedEndTimes);
            return this;
        }

        @Override
        public BatchGetFrameMetricDataResponse build() {
            return new BatchGetFrameMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
