/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the createProfiliingGroupRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProfilingGroupRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<CreateProfilingGroupRequest.Builder, CreateProfilingGroupRequest> {
    private static final SdkField<AgentOrchestrationConfig> AGENT_ORCHESTRATION_CONFIG_FIELD = SdkField
            .<AgentOrchestrationConfig> builder(MarshallingType.SDK_POJO).memberName("agentOrchestrationConfig")
            .getter(getter(CreateProfilingGroupRequest::agentOrchestrationConfig))
            .setter(setter(Builder::agentOrchestrationConfig)).constructor(AgentOrchestrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentOrchestrationConfig").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateProfilingGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computePlatform").getter(getter(CreateProfilingGroupRequest::computePlatformAsString))
            .setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(CreateProfilingGroupRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupName").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateProfilingGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AGENT_ORCHESTRATION_CONFIG_FIELD, CLIENT_TOKEN_FIELD, COMPUTE_PLATFORM_FIELD,
                    PROFILING_GROUP_NAME_FIELD, TAGS_FIELD));

    private final AgentOrchestrationConfig agentOrchestrationConfig;

    private final String clientToken;

    private final String computePlatform;

    private final String profilingGroupName;

    private final Map<String, String> tags;

    private CreateProfilingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentOrchestrationConfig = builder.agentOrchestrationConfig;
        this.clientToken = builder.clientToken;
        this.computePlatform = builder.computePlatform;
        this.profilingGroupName = builder.profilingGroupName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies whether profiling is enabled or disabled for the created profiling group.
     * </p>
     * 
     * @return Specifies whether profiling is enabled or disabled for the created profiling group.
     */
    public final AgentOrchestrationConfig agentOrchestrationConfig() {
        return agentOrchestrationConfig;
    }

    /**
     * <p>
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of
     * duplicate profiling groups if there are failures and retries.
     * </p>
     * 
     * @return Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental
     *         creation of duplicate profiling groups if there are failures and retries.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS Lambda.
     * Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such an Amazon
     * EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS
     *         Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda,
     *         such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified,
     *         <code>Default</code> is used.
     * @see ComputePlatform
     */
    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS Lambda.
     * Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such an Amazon
     * EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS
     *         Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda,
     *         such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified,
     *         <code>Default</code> is used.
     * @see ComputePlatform
     */
    public final String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * <p>
     * The name of the profiling group to create.
     * </p>
     * 
     * @return The name of the profiling group to create.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the created profiling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to add to the created profiling group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentOrchestrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfilingGroupRequest)) {
            return false;
        }
        CreateProfilingGroupRequest other = (CreateProfilingGroupRequest) obj;
        return Objects.equals(agentOrchestrationConfig(), other.agentOrchestrationConfig())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && Objects.equals(profilingGroupName(), other.profilingGroupName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProfilingGroupRequest").add("AgentOrchestrationConfig", agentOrchestrationConfig())
                .add("ClientToken", clientToken()).add("ComputePlatform", computePlatformAsString())
                .add("ProfilingGroupName", profilingGroupName()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentOrchestrationConfig":
            return Optional.ofNullable(clazz.cast(agentOrchestrationConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfilingGroupRequest, T> g) {
        return obj -> g.apply((CreateProfilingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProfilingGroupRequest> {
        /**
         * <p>
         * Specifies whether profiling is enabled or disabled for the created profiling group.
         * </p>
         * 
         * @param agentOrchestrationConfig
         *        Specifies whether profiling is enabled or disabled for the created profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig);

        /**
         * <p>
         * Specifies whether profiling is enabled or disabled for the created profiling group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentOrchestrationConfig.Builder}
         * avoiding the need to create one manually via {@link AgentOrchestrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgentOrchestrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #agentOrchestrationConfig(AgentOrchestrationConfig)}.
         * 
         * @param agentOrchestrationConfig
         *        a consumer that will call methods on {@link AgentOrchestrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentOrchestrationConfig(AgentOrchestrationConfig)
         */
        default Builder agentOrchestrationConfig(Consumer<AgentOrchestrationConfig.Builder> agentOrchestrationConfig) {
            return agentOrchestrationConfig(AgentOrchestrationConfig.builder().applyMutation(agentOrchestrationConfig).build());
        }

        /**
         * <p>
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of
         * duplicate profiling groups if there are failures and retries.
         * </p>
         * 
         * @param clientToken
         *        Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental
         *        creation of duplicate profiling groups if there are failures and retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS
         * Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such
         * an Amazon EC2 instance, an on-premises server, or a different platform. If not specified,
         * <code>Default</code> is used.
         * </p>
         * 
         * @param computePlatform
         *        The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on
         *        AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS
         *        Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified,
         *        <code>Default</code> is used.
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS
         * Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such
         * an Amazon EC2 instance, an on-premises server, or a different platform. If not specified,
         * <code>Default</code> is used.
         * </p>
         * 
         * @param computePlatform
         *        The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on
         *        AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS
         *        Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified,
         *        <code>Default</code> is used.
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The name of the profiling group to create.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * A list of tags to add to the created profiling group.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the created profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private AgentOrchestrationConfig agentOrchestrationConfig;

        private String clientToken;

        private String computePlatform;

        private String profilingGroupName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfilingGroupRequest model) {
            super(model);
            agentOrchestrationConfig(model.agentOrchestrationConfig);
            clientToken(model.clientToken);
            computePlatform(model.computePlatform);
            profilingGroupName(model.profilingGroupName);
            tags(model.tags);
        }

        public final AgentOrchestrationConfig.Builder getAgentOrchestrationConfig() {
            return agentOrchestrationConfig != null ? agentOrchestrationConfig.toBuilder() : null;
        }

        public final void setAgentOrchestrationConfig(AgentOrchestrationConfig.BuilderImpl agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig != null ? agentOrchestrationConfig.build() : null;
        }

        @Override
        public final Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getComputePlatform() {
            return computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfilingGroupRequest build() {
            return new CreateProfilingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
