/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the listProfilingGroupsRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfilingGroupsRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<ListProfilingGroupsRequest.Builder, ListProfilingGroupsRequest> {
    private static final SdkField<Boolean> INCLUDE_DESCRIPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeDescription").getter(getter(ListProfilingGroupsRequest::includeDescription))
            .setter(setter(Builder::includeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeDescription").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListProfilingGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProfilingGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_DESCRIPTION_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final Boolean includeDescription;

    private final Integer maxResults;

    private final String nextToken;

    private ListProfilingGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.includeDescription = builder.includeDescription;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling groups is
     * returned. If <code>false</code>, then a list of profiling group names is returned.
     * </p>
     * 
     * @return A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a
     *         list of <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     *         <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling
     *         groups is returned. If <code>false</code>, then a list of profiling group names is returned.
     */
    public final Boolean includeDescription() {
        return includeDescription;
    }

    /**
     * <p>
     * The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in paginated output.
     * When this parameter is used, <code>ListProfilingGroups</code> only returns <code>maxResults</code> results in a
     * single page along with a <code>nextToken</code> response element. The remaining results of the initial request
     * can be seen by sending another <code>ListProfilingGroups</code> request with the returned <code>nextToken</code>
     * value.
     * </p>
     * 
     * @return The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in paginated
     *         output. When this parameter is used, <code>ListProfilingGroups</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>ListProfilingGroups</code> request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         </p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilingGroupsRequest)) {
            return false;
        }
        ListProfilingGroupsRequest other = (ListProfilingGroupsRequest) obj;
        return Objects.equals(includeDescription(), other.includeDescription())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfilingGroupsRequest").add("IncludeDescription", includeDescription())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeDescription":
            return Optional.ofNullable(clazz.cast(includeDescription()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilingGroupsRequest, T> g) {
        return obj -> g.apply((ListProfilingGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProfilingGroupsRequest> {
        /**
         * <p>
         * A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a list
         * of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling groups
         * is returned. If <code>false</code>, then a list of profiling group names is returned.
         * </p>
         * 
         * @param includeDescription
         *        A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a
         *        list of <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling
         *        groups is returned. If <code>false</code>, then a list of profiling group names is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDescription(Boolean includeDescription);

        /**
         * <p>
         * The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in paginated
         * output. When this parameter is used, <code>ListProfilingGroups</code> only returns <code>maxResults</code>
         * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
         * initial request can be seen by sending another <code>ListProfilingGroups</code> request with the returned
         * <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in
         *        paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>ListProfilingGroups</code> request with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. </p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private Boolean includeDescription;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilingGroupsRequest model) {
            super(model);
            includeDescription(model.includeDescription);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Boolean getIncludeDescription() {
            return includeDescription;
        }

        public final void setIncludeDescription(Boolean includeDescription) {
            this.includeDescription = includeDescription;
        }

        @Override
        public final Builder includeDescription(Boolean includeDescription) {
            this.includeDescription = includeDescription;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfilingGroupsRequest build() {
            return new ListProfilingGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
