/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the postAgentProfileRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostAgentProfileRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<PostAgentProfileRequest.Builder, PostAgentProfileRequest> {
    private static final SdkField<SdkBytes> AGENT_PROFILE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("agentProfile")
            .getter(getter(PostAgentProfileRequest::agentProfile))
            .setter(setter(Builder::agentProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentProfile").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PostAgentProfileRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> PROFILE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("profileToken")
            .getter(getter(PostAgentProfileRequest::profileToken))
            .setter(setter(Builder::profileToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("profileToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(PostAgentProfileRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_PROFILE_FIELD,
            CONTENT_TYPE_FIELD, PROFILE_TOKEN_FIELD, PROFILING_GROUP_NAME_FIELD));

    private final SdkBytes agentProfile;

    private final String contentType;

    private final String profileToken;

    private final String profilingGroupName;

    private PostAgentProfileRequest(BuilderImpl builder) {
        super(builder);
        this.agentProfile = builder.agentProfile;
        this.contentType = builder.contentType;
        this.profileToken = builder.profileToken;
        this.profilingGroupName = builder.profilingGroupName;
    }

    /**
     * <p>
     * The submitted profiling data.
     * </p>
     * 
     * @return The submitted profiling data.
     */
    public final SdkBytes agentProfile() {
        return agentProfile;
    }

    /**
     * <p>
     * The format of the submitted profiling data. The format maps to the <code>Accept</code> and
     * <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default .
     * </p>
     * 
     * <pre>
     * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
     * </pre>
     * 
     * @return The format of the submitted profiling data. The format maps to the <code>Accept</code> and
     *         <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the
     *         default . </p>
     * 
     * <pre><code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of
     * duplicate profiling data if there are failures and retries.
     * </p>
     * 
     * @return Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental
     *         submission of duplicate profiling data if there are failures and retries.
     */
    public final String profileToken() {
        return profileToken;
    }

    /**
     * <p>
     * The name of the profiling group with the aggregated profile that receives the submitted profiling data.
     * </p>
     * 
     * @return The name of the profiling group with the aggregated profile that receives the submitted profiling data.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentProfile());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(profileToken());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostAgentProfileRequest)) {
            return false;
        }
        PostAgentProfileRequest other = (PostAgentProfileRequest) obj;
        return Objects.equals(agentProfile(), other.agentProfile()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(profileToken(), other.profileToken())
                && Objects.equals(profilingGroupName(), other.profilingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostAgentProfileRequest").add("AgentProfile", agentProfile()).add("ContentType", contentType())
                .add("ProfileToken", profileToken()).add("ProfilingGroupName", profilingGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentProfile":
            return Optional.ofNullable(clazz.cast(agentProfile()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "profileToken":
            return Optional.ofNullable(clazz.cast(profileToken()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostAgentProfileRequest, T> g) {
        return obj -> g.apply((PostAgentProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, PostAgentProfileRequest> {
        /**
         * <p>
         * The submitted profiling data.
         * </p>
         * 
         * @param agentProfile
         *        The submitted profiling data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentProfile(SdkBytes agentProfile);

        /**
         * <p>
         * The format of the submitted profiling data. The format maps to the <code>Accept</code> and
         * <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default .
         * </p>
         * 
         * <pre>
         * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
         * </pre>
         * 
         * @param contentType
         *        The format of the submitted profiling data. The format maps to the <code>Accept</code> and
         *        <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the
         *        default . </p>
         * 
         *        <pre>
         * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission
         * of duplicate profiling data if there are failures and retries.
         * </p>
         * 
         * @param profileToken
         *        Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental
         *        submission of duplicate profiling data if there are failures and retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileToken(String profileToken);

        /**
         * <p>
         * The name of the profiling group with the aggregated profile that receives the submitted profiling data.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group with the aggregated profile that receives the submitted profiling
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private SdkBytes agentProfile;

        private String contentType;

        private String profileToken;

        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(PostAgentProfileRequest model) {
            super(model);
            agentProfile(model.agentProfile);
            contentType(model.contentType);
            profileToken(model.profileToken);
            profilingGroupName(model.profilingGroupName);
        }

        public final ByteBuffer getAgentProfile() {
            return agentProfile == null ? null : agentProfile.asByteBuffer();
        }

        public final void setAgentProfile(ByteBuffer agentProfile) {
            agentProfile(agentProfile == null ? null : SdkBytes.fromByteBuffer(agentProfile));
        }

        @Override
        public final Builder agentProfile(SdkBytes agentProfile) {
            this.agentProfile = agentProfile;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getProfileToken() {
            return profileToken;
        }

        public final void setProfileToken(String profileToken) {
            this.profileToken = profileToken;
        }

        @Override
        public final Builder profileToken(String profileToken) {
            this.profileToken = profileToken;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostAgentProfileRequest build() {
            return new PostAgentProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
